/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import team.tnt.collectorsalbum.platform.Side;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.NetworkMessage;
import team.tnt.collectorsalbum.platform.network.PacketHolder;

public final class ForgeNetwork
implements Network {
    private SimpleChannel channel;
    private int messageId;

    @Override
    public void initialize(ResourceLocation identifier, Side side, List<PacketHolder<?, ?>> c2s, List<PacketHolder<?, ?>> s2c) {
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)identifier).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> s.equals("1")).serverAcceptedVersions(s -> s.equals("1")).simpleChannel();
        for (PacketHolder<?, ?> holder : c2s) {
            this.registerInternal(holder);
        }
        for (PacketHolder<?, ?> holder : s2c) {
            this.registerInternal(holder);
        }
    }

    @Override
    public void sendServerMessage(NetworkMessage payload) {
        this.channel.sendToServer((Object)payload);
    }

    @Override
    public void sendClientMessage(ServerPlayer player, NetworkMessage payload) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)payload);
    }

    private <T extends NetworkMessage> void registerInternal(PacketHolder<T, ?> holder) {
        this.channel.messageBuilder(holder.payloadType(), this.messageId++).encoder(NetworkMessage::write).decoder(holder.decoder()).consumerMainThread((t, contextSupplier) -> {
            Player player = this.getPlayer((NetworkEvent.Context)contextSupplier.get());
            t.handle(player);
        }).add();
    }

    private Player getPlayer(NetworkEvent.Context ctx) {
        if (ctx.getDirection().getReceptionSide().isServer()) {
            return ctx.getSender();
        }
        return this.getLocalPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    private Player getLocalPlayer() {
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91074_;
    }
}

