/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class Codecs {
    public static final Codec<Float> PERCENT_FLOAT = Codecs.rangeInclusiveFloat(0.0f, 1.0f);
    public static final Codec<Integer> COLOR_CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.comapFlatMap(text -> {
        try {
            int color = Integer.decode(text);
            return DataResult.success((Object)color);
        }
        catch (NumberFormatException e) {
            return DataResult.error(e::getMessage);
        }
    }, Integer::toHexString)).xmap(either -> (Integer)either.map(Function.identity(), Function.identity()), Either::left);
    public static final Codec<Holder<Item>> ITEM_NON_AIR_CODEC = Codecs.validate(BuiltInRegistries.f_257033_.m_206110_(), (T item) -> item.m_203565_(Items.f_41852_.m_204114_().m_205785_()) ? DataResult.error(() -> "Item must not be minecraft:air!") : DataResult.success((Object)item));
    public static final Codec<UUID> UUID_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid UUID: " + string + ", " + e.getMessage());
        }
    }, UUID::toString);
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::m_220173_), (App)ExtraCodecs.m_269197_((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.m_41783_()))).apply((Applicative)instance, (holder, count, tag) -> {
        ItemStack itemStack = new ItemStack(holder, count.intValue());
        tag.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
        return itemStack;
    }));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = ITEM_NON_AIR_CODEC.xmap(ItemStack::new, ItemStack::m_220173_);

    public static <T> Codec<T> validate(Codec<T> codec, Function<T, DataResult<T>> validator) {
        return codec.flatXmap(validator, validator);
    }

    public static <T> MapCodec<T> validate(MapCodec<T> codec, Function<T, DataResult<T>> validator) {
        return codec.flatXmap(validator, validator);
    }

    public static Codec<Float> rangeInclusiveFloat(float min, float max) {
        return Codecs.validate(Codec.FLOAT, (T f) -> f.floatValue() >= min && f.floatValue() <= max ? DataResult.success((Object)f) : DataResult.error(() -> String.format("Value [%f] is not within required range [%f;%f]", f, Float.valueOf(min), Float.valueOf(max))));
    }

    public static <T> Codec<T[]> array(Codec<T> codec, IntFunction<T[]> toArray) {
        return Codecs.array(codec, toArray, Arrays::asList);
    }

    public static <T> Codec<T[]> array(Codec<T> codec, IntFunction<T[]> toArray, Function<T[], List<T>> toList) {
        return codec.listOf().xmap(list -> {
            Object[] values = (Object[])toArray.apply(list.size());
            for (int i = 0; i < list.size(); ++i) {
                values[i] = list.get(i);
            }
            return values;
        }, toList);
    }

    public static <T> Codec<Supplier<T>> supplier(Codec<T> codec) {
        return codec.xmap(t -> () -> t, Supplier::get);
    }

    public static <T, C extends Collection<T>> DataResult<C> requireSize(C collection, int size) {
        return collection.size() != size ? DataResult.error(() -> String.format("Collection must contain exactly %d elements, found %d!", size, collection.size())) : DataResult.success(collection);
    }

    public static <T> Codec<Set<T>> setCodec(Codec<T> codec) {
        return Codecs.setCodec(codec, HashSet::new);
    }

    public static <T> Codec<Set<T>> setCodec(Codec<T> codec, Function<List<T>, Set<T>> codecFactory) {
        return codec.listOf().xmap(codecFactory, ArrayList::new);
    }

    public static <T> Codec<NonNullList<T>> nonNullListCodec(Codec<T> codec, T empty) {
        return codec.listOf().xmap(list -> {
            NonNullList nonNullList = NonNullList.m_122780_((int)list.size(), (Object)empty);
            for (int i = 0; i < list.size(); ++i) {
                nonNullList.set(i, list.get(i));
            }
            return nonNullList;
        }, Function.identity());
    }

    public static Codec<Float> minFloat(float min) {
        return Codecs.rangeInclusiveFloat(min, Float.MAX_VALUE);
    }

    public static Codec<Float> maxFloat(float max) {
        return Codecs.rangeInclusiveFloat(-3.4028235E38f, max);
    }

    public static <E extends Enum<E>> Codec<E> simpleEnumCodec(Class<E> type) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, s), Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> simpleEnumCodec(Class<E> type, UnaryOperator<String> nameTransform) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, (String)nameTransform.apply((String)s)), Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> enumCodecWithEncoder(Class<E> type, Function<E, String> encoder) {
        return Codecs.enumCodec(type, s -> Enum.valueOf(type, s), encoder);
    }

    public static <E extends Enum<E>> Codec<E> enumCodecWithDecoder(Class<E> type, Function<String, E> decoder) {
        return Codecs.enumCodec(type, decoder, Enum::name);
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> type, Function<String, E> decoder, Function<E, String> encoder) {
        return Codec.STRING.flatXmap(key -> {
            try {
                Enum value = (Enum)decoder.apply((String)key);
                return DataResult.success((Object)value);
            }
            catch (Exception e) {
                return DataResult.error(() -> String.format("Failed to decode enum '%s' due to error %s", type.getSimpleName(), e));
            }
        }, value -> {
            try {
                String key = (String)encoder.apply(value);
                return DataResult.success((Object)key);
            }
            catch (Exception e) {
                return DataResult.error(() -> String.format("Failed to encode enum to text for provided value '%s' due to error %s", value, e));
            }
        });
    }
}

