/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;

public class RandomListItemDropProvider
implements ItemDropProvider {
    public static final MapCodec<RandomListItemDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemDropProviderType.INSTANCE_CODEC.listOf().fieldOf("items").forGetter(t -> t.items)).apply((Applicative)instance, RandomListItemDropProvider::new));
    private final List<ItemDropProvider> items;

    public RandomListItemDropProvider(List<ItemDropProvider> items) {
        this.items = items;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        RandomSource randomSource = context.getOrThrow("random", RandomSource.class);
        if (this.items.isEmpty()) {
            return;
        }
        int index = randomSource.m_188503_(this.items.size());
        ItemDropProvider provider = this.items.get(index);
        provider.generateDrops(context, output);
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.RANDOM_ITEM_DROP_PROVIDER.get();
    }
}

