/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;

public class EntityFilterItemDropProvider
implements ItemDropProvider {
    public static final MapCodec<EntityFilterItemDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256939_).fieldOf("filter").forGetter(t -> t.filter), (App)ItemDropProviderType.INSTANCE_CODEC.fieldOf("pass").forGetter(t -> t.pass), (App)ItemDropProviderType.INSTANCE_CODEC.optionalFieldOf("fail", (Object)NoItemDropProvider.INSTANCE).forGetter(t -> t.fail)).apply((Applicative)instance, EntityFilterItemDropProvider::new));
    private final TagKey<EntityType<?>> filter;
    private final ItemDropProvider pass;
    private final ItemDropProvider fail;

    public EntityFilterItemDropProvider(TagKey<EntityType<?>> filter, ItemDropProvider pass, ItemDropProvider fail) {
        this.filter = filter;
        this.pass = pass;
        this.fail = fail;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        Entity entity = context.getNullable("entity", Entity.class);
        if (entity == null) {
            CollectorsAlbum.LOGGER.warn("Failed to generate item drop, 'entity' key is not found in drop context!");
            return;
        }
        EntityType entityType = entity.m_6095_();
        if (entityType.m_204039_(this.filter)) {
            this.pass.generateDrops(context, output);
        } else {
            this.fail.generateDrops(context, output);
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.ENTITY_FILTER.get();
    }
}

