/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.drops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.MobAdditionalDropManager;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.OutputBuilder;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public class DropReferenceProvider
implements ItemDropProvider {
    public static final MapCodec<DropReferenceProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("reference").forGetter(t -> t.reference)).apply((Applicative)instance, DropReferenceProvider::new));
    private final ResourceLocation reference;

    public DropReferenceProvider(ResourceLocation reference) {
        this.reference = reference;
    }

    @Override
    public void generateDrops(ActionContext context, OutputBuilder<ItemStack> output) {
        Entity entity = context.getNullable("entity", Entity.class);
        PlatformGsonCodecReloadListener manager = entity != null ? MobAdditionalDropManager.getInstance() : CardPackDropManager.getInstance();
        ItemDropProvider provider = manager.getProvider(this.reference);
        provider.generateDrops(context, output);
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return (ItemDropProviderType)ItemDropProviderRegistry.REFERENCE.get();
    }
}

