/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.platform.Codecs;

public class AttributeAlbumBonus
implements AlbumBonus {
    public static final Codec<AttributeModifier> CONFIGURABLE_MODIFIER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.UUID_CODEC.fieldOf("id").forGetter(AttributeModifier::m_22209_), (App)Codec.either((Codec)Codec.DOUBLE, NumberProviderType.INSTANCE_CODEC).fieldOf("amount").forGetter(t -> Either.left((Object)t.m_22218_())), (App)Codecs.simpleEnumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(AttributeModifier::m_22217_)).apply((Applicative)instance, (id, either, op) -> new AttributeModifier(id, "", ((Double)either.map(Function.identity(), NumberProvider::doubleValue)).doubleValue(), op)));
    public static final MapCodec<AttributeAlbumBonus> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256951_.m_206110_().fieldOf("attribute").forGetter(t -> t.attribute), (App)CONFIGURABLE_MODIFIER_CODEC.fieldOf("modifier").forGetter(t -> t.attributeModifier)).apply((Applicative)instance, AttributeAlbumBonus::new));
    private static final String LABEL_ATTRIBUTE = "collectorsalbum.label.bonus.attribute";
    private static final String LABEL_ATTRIBUTE_MODIFIER = "collectorsalbum.label.bonus.attribute_modifier";
    private static final String TOOL_ATTRIBUTE_OPERATION = "collectorsalbum.tooltip.bonus.attribute_operation";
    private final Holder<Attribute> attribute;
    private final AttributeModifier attributeModifier;

    public AttributeAlbumBonus(Holder<Attribute> attribute, AttributeModifier attributeModifier) {
        this.attribute = attribute;
        this.attributeModifier = attributeModifier;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        Attribute unwrappedAttribute = (Attribute)this.attribute.m_203334_();
        MutableComponent attributeName = Component.m_237115_((String)unwrappedAttribute.m_22087_());
        description.text((Component)Component.m_237110_((String)LABEL_ATTRIBUTE, (Object[])new Object[]{attributeName}));
        description.text((Component)Component.m_237110_((String)LABEL_ATTRIBUTE_MODIFIER, (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.attributeModifier.m_22218_())).m_130940_(ChatFormatting.GREEN)}), (Component)Component.m_237110_((String)TOOL_ATTRIBUTE_OPERATION, (Object[])new Object[]{Component.m_237113_((String)this.attributeModifier.m_22217_().name())}));
    }

    @Override
    public void apply(ActionContext context) {
        AttributeModifier activeModifier;
        Player player = context.getOrThrow("player", Player.class);
        AttributeInstance instance = player.m_21051_((Attribute)this.attribute.m_203334_());
        if (!(instance == null || (activeModifier = instance.m_22111_(this.attributeModifier.m_22209_())) != null && activeModifier.equals((Object)this.attributeModifier))) {
            instance.m_22130_(this.attributeModifier);
            instance.m_22125_(this.attributeModifier);
        }
    }

    @Override
    public void removed(ActionContext context) {
        AttributeModifier modifier;
        Player player = context.getOrThrow("player", Player.class);
        AttributeInstance instance = player.m_21051_((Attribute)this.attribute.m_203334_());
        if (instance != null && this.attributeModifier.equals((Object)(modifier = instance.m_22111_(this.attributeModifier.m_22209_())))) {
            instance.m_22130_(this.attributeModifier);
        }
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.ATTRIBUTE.get();
    }
}

