/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Player;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumMobEffectBonus
implements AlbumBonus {
    public static final MapCodec<AlbumMobEffectBonus> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("rewriteExisting", (Object)false).forGetter(t -> t.rewriteExisting), (App)Codec.BOOL.optionalFieldOf("forceRemove", (Object)false).forGetter(t -> t.forceRemove), (App)BuiltInRegistries.f_256974_.m_206110_().fieldOf("effect").forGetter(t -> t.effect), (App)Codec.either((Codec)ExtraCodecs.f_144629_, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("duration", (Object)Either.left((Object)120)).forGetter(t -> Either.right((Object)t.duration)), (App)Codec.either((Codec)ExtraCodecs.m_269197_((int)0, (int)255), NumberProviderType.INSTANCE_CODEC).optionalFieldOf("amplifier", (Object)Either.right((Object)ConstantNumberProvider.ZERO)).forGetter(t -> Either.right((Object)t.amplifier)), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)true).forGetter(t -> t.ambient), (App)Codec.BOOL.optionalFieldOf("visible", (Object)false).forGetter(t -> t.visible), (App)Codec.BOOL.optionalFieldOf("showIcon", (Object)true).forGetter(t -> t.showIcon)).apply((Applicative)instance, AlbumMobEffectBonus::new));
    private final boolean rewriteExisting;
    private final boolean forceRemove;
    private final Holder<MobEffect> effect;
    private final NumberProvider duration;
    private final NumberProvider amplifier;
    private final boolean ambient;
    private final boolean visible;
    private final boolean showIcon;

    public AlbumMobEffectBonus(boolean rewriteExisting, boolean forceRemove, Holder<MobEffect> effect, Either<Integer, NumberProvider> duration, Either<Integer, NumberProvider> amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this.rewriteExisting = rewriteExisting;
        this.forceRemove = forceRemove;
        this.effect = effect;
        this.duration = (NumberProvider)duration.map(ConstantNumberProvider::new, Function.identity());
        this.amplifier = (NumberProvider)amplifier.map(ConstantNumberProvider::new, Function.identity());
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
    }

    @Override
    public void addDescription(AlbumBonusDescriptionOutput description) {
        MobEffect mobEffect = (MobEffect)this.effect.m_203334_();
        int amplifierValue = this.amplifier.intValue();
        ActionContext context = description.getContext();
        Player player = context.getOrThrow("player", Player.class);
        Component amplifier = amplifierValue >= 1 && amplifierValue <= 9 ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (amplifierValue + 1)))) : CommonComponents.f_237098_;
        MutableComponent title = Component.m_237110_((String)"collectorsalbum.label.bonus.mob_effect.effect", (Object[])new Object[]{mobEffect.m_19482_(), amplifier}).m_130940_(ChatFormatting.BLUE);
        MutableComponent tooltip = Component.m_237110_((String)"collectorsalbum.label.bonus.mob_effect.duration", (Object[])new Object[]{MobEffectUtil.m_267641_((MobEffectInstance)this.createEffectInstance(), (float)1.0f)});
        description.text((Component)title, (Component)tooltip);
    }

    @Override
    public void apply(ActionContext context) {
        MobEffectInstance instance;
        Player player = context.getOrThrow("player", Player.class);
        if (!player.m_7292_(instance = this.createEffectInstance()) && this.rewriteExisting) {
            player.m_21195_((MobEffect)this.effect.m_203334_());
            player.m_7292_(instance);
        }
    }

    @Override
    public void removed(ActionContext context) {
        if (this.forceRemove) {
            Player player = context.getOrThrow("player", Player.class);
            player.m_21195_((MobEffect)this.effect.m_203334_());
        }
    }

    @Override
    public AlbumBonusType<?> getType() {
        return (AlbumBonusType)AlbumBonusRegistry.MOB_EFFECT.get();
    }

    private MobEffectInstance createEffectInstance() {
        return new MobEffectInstance((MobEffect)this.effect.m_203334_(), this.duration.intValue(), this.amplifier.intValue(), this.ambient, this.visible, this.showIcon);
    }
}

