/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.ListBasedOutputBuilder;
import team.tnt.collectorsalbum.network.S2C_OpenCardPackScreen;
import team.tnt.collectorsalbum.platform.Codecs;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CardPackItem
extends Item {
    public static final int MAX_PACK_CARDS = 18;
    public static final Component USAGE = Component.m_237115_((String)"collectorsalbum.label.use_open").m_130940_(ChatFormatting.GRAY);
    public static final Component LABEL_UNSET = Component.m_237115_((String)"collectorsalbum.label.not_set").m_130940_(ChatFormatting.RED);
    public static final Component WARN_NO_DROPS = Component.m_237115_((String)"collectorsalbum.label.pack_empty").m_130940_(ChatFormatting.GOLD);
    public static final String NBT_CUSTOM_DROP_TABLE = "collectorsalbum:packs_drop_table";
    private final ResourceLocation lootDataSourcePath;

    public CardPackItem(Item.Properties properties) {
        this(properties, null);
    }

    public CardPackItem(Item.Properties properties, ResourceLocation lootDataSourcePath) {
        super(properties);
        this.lootDataSourcePath = lootDataSourcePath;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        player.m_5496_((SoundEvent)SoundRegistry.PACK_OPEN.get(), 1.0f, 1.0f);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack itemStack) {
        return 20;
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!level.m_5776_()) {
                ListBasedOutputBuilder<ItemStack> outputs = ListBasedOutputBuilder.createArrayListBased();
                ItemDropProvider provider = this.getDropTable(itemStack);
                ActionContext context = ActionContext.of("player", player, "itemstack", itemStack, "random", player.m_217043_());
                provider.generateDrops(context, outputs);
                AlbumCardManager cardManager = AlbumCardManager.getInstance();
                List<ItemStack> validDrops = outputs.getItems().stream().filter(stack -> cardManager.isCard(stack.m_41720_())).map(ItemStack::m_41777_).collect(Collectors.toList());
                CollectorsAlbum.LOGGER.debug("{} is opening card pack {} with generated content: {}", (Object)entity, (Object)this, validDrops);
                if (!validDrops.isEmpty()) {
                    Collections.shuffle(validDrops);
                    PackContents contents = new PackContents(validDrops);
                    PackContents.set(itemStack, contents);
                    PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_OpenCardPackScreen(validDrops));
                } else {
                    player.m_5661_(WARN_NO_DROPS, true);
                }
                player.m_36335_().m_41524_((Item)this, 20);
            }
        }
        return itemStack;
    }

    protected ItemDropProvider getDropTable(ItemStack itemStack) {
        CardPackDropManager manager = CardPackDropManager.getInstance();
        Optional<ResourceLocation> customPath = CardPackItem.getCustomDropTable(itemStack);
        if (customPath.isPresent()) {
            return manager.getEitherProvider(customPath.get(), this.lootDataSourcePath);
        }
        if (this.lootDataSourcePath != null) {
            return manager.getProvider(this.lootDataSourcePath);
        }
        return NoItemDropProvider.INSTANCE;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add(USAGE);
        Optional<ResourceLocation> customTable = CardPackItem.getCustomDropTable(itemStack);
        if (customTable.isPresent()) {
            MutableComponent customTableLabel = Component.m_237113_((String)customTable.get().toString()).m_130940_(ChatFormatting.GREEN);
            components.add((Component)Component.m_237110_((String)"collectorsalbum.label.custom_drop_table", (Object[])new Object[]{customTableLabel}).m_130940_(ChatFormatting.GRAY));
        } else if (this.lootDataSourcePath == null) {
            components.add((Component)Component.m_237110_((String)"collectorsalbum.label.custom_drop_table", (Object[])new Object[]{LABEL_UNSET}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static Optional<ResourceLocation> getCustomDropTable(ItemStack itemStack) {
        if (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128425_(NBT_CUSTOM_DROP_TABLE, 8)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new ResourceLocation(itemStack.m_41783_().m_128461_(NBT_CUSTOM_DROP_TABLE)));
        }
        catch (Exception e) {
            CollectorsAlbum.LOGGER.error("Attempted to load invalid resource location format for card pack drops path, ended up with error", (Throwable)e);
            return Optional.empty();
        }
    }

    public record PackContents(List<ItemStack> contents) {
        public static final String NBT_PACK_CONTENTS = "collectorsalbum:pack_contents";
        public static final Codec<PackContents> CODEC = Codecs.SINGLE_ITEM_CODEC.listOf().xmap(PackContents::new, contents -> contents.contents);

        public boolean isEmpty() {
            return this.contents.isEmpty();
        }

        public static void set(ItemStack itemStack, PackContents pack) {
            if (pack == null || pack.contents() == null || pack.contents().isEmpty()) {
                if (itemStack.m_41783_() != null) {
                    itemStack.m_41783_().m_128473_(NBT_PACK_CONTENTS);
                }
                return;
            }
            DataResult encodeResult = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pack);
            encodeResult.result().ifPresent(tag -> itemStack.m_41784_().m_128365_(NBT_PACK_CONTENTS, tag));
        }

        @Nullable
        public static PackContents get(ItemStack itemStack) {
            if (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128425_(NBT_PACK_CONTENTS, 9)) {
                return null;
            }
            DataResult dataResult = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)itemStack.m_41784_().m_128423_(NBT_PACK_CONTENTS));
            return dataResult.result().orElse(null);
        }
    }
}

