/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.card.CardFilter;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.init.CardTypeRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.platform.Codecs;

public class SimpleCard
implements AlbumCard {
    public static final MapCodec<SimpleCard> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(SimpleCard::identifier), (App)Codecs.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(SimpleCard::asItem), (App)ResourceLocation.f_135803_.fieldOf("category").forGetter(SimpleCard::category), (App)CardUiTemplate.CODEC.optionalFieldOf("template", (Object)CardUiTemplate.TEMPLATE).forGetter(SimpleCard::template), (App)Codec.INT.optionalFieldOf("points", (Object)0).forGetter(SimpleCard::getPoints), (App)ExtraCodecs.f_144629_.fieldOf("number").forGetter(SimpleCard::cardNumber)).apply((Applicative)instance, SimpleCard::new));
    private final ResourceLocation cardId;
    private final ItemStack item;
    private final ResourceLocation category;
    private final CardUiTemplate template;
    private final int points;
    private final int number;
    private AlbumCategory cachedCategory;

    public SimpleCard(ResourceLocation cardId, ItemStack item, ResourceLocation category, CardUiTemplate template, int points, int number) {
        this.cardId = cardId;
        this.item = item;
        this.category = category;
        this.template = template;
        this.points = points;
        this.number = number;
    }

    @Override
    public int cardNumber() {
        return this.number;
    }

    @Override
    public int getPoints() {
        return this.points;
    }

    @Override
    public ResourceLocation category() {
        return this.category;
    }

    @Override
    public CardUiTemplate template() {
        return this.template;
    }

    @Override
    public ItemStack asItem() {
        return this.item;
    }

    @Override
    public ResourceLocation identifier() {
        return this.cardId;
    }

    @Override
    public boolean test(CardFilter filter) {
        if (!filter.numberFilter().test(this.number)) {
            return false;
        }
        return filter.pointFilter().test(this.points);
    }

    @Override
    public void appendItemStackHoverTooltip(ItemStack itemStack, List<Component> tooltips, TooltipFlag flag) {
        tooltips.add(CardUiTemplate.DEFAULT_CARD_INFO_HEADER);
        tooltips.add((Component)CardUiTemplate.getCardNumberTooltip(this.number));
        tooltips.add((Component)CardUiTemplate.getCardCategoryTooltip(this));
        int points = this.getPoints();
        if (points > 0) {
            tooltips.add((Component)CardUiTemplate.getCardPointsTooltip(points));
        }
    }

    @Override
    public AlbumCardType<?> getType() {
        return (AlbumCardType)CardTypeRegistry.CARD.get();
    }

    @Override
    public AlbumCategory getLinkedCategory() {
        if (this.cachedCategory == null) {
            this.cachedCategory = AlbumCategoryManager.getInstance().findById(this.category).orElseThrow();
        }
        return this.cachedCategory;
    }
}

