/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import team.tnt.collectorsalbum.common.resource.function.ConstantNumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;

public record IntFilter(NumberProvider min, NumberProvider max) {
    public static final MapCodec<IntFilter> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.INT, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("min", (Object)Either.left((Object)Integer.MIN_VALUE)).forGetter(v -> Either.right((Object)v.min)), (App)Codec.either((Codec)Codec.INT, NumberProviderType.INSTANCE_CODEC).optionalFieldOf("max", (Object)Either.left((Object)Integer.MAX_VALUE)).forGetter(v -> Either.right((Object)v.max))).apply((Applicative)instance, IntFilter::new));
    public static final Codec<IntFilter> CODEC = MAP_CODEC.codec();
    public static final IntFilter NO_FILTER = new IntFilter(new ConstantNumberProvider(-2.147483648E9), new ConstantNumberProvider(2.147483647E9));

    private IntFilter(Either<Integer, NumberProvider> min, Either<Integer, NumberProvider> max) {
        this((NumberProvider)min.map(ConstantNumberProvider::new, Function.identity()), (NumberProvider)max.map(ConstantNumberProvider::new, Function.identity()));
    }

    public boolean test(int value) {
        return value >= this.min.intValue() && value <= this.max.intValue();
    }

    public Component getDisplayComponent() {
        int from = this.min.intValue();
        int to = this.max.intValue();
        if (from > Integer.MIN_VALUE && to < Integer.MAX_VALUE) {
            return Component.m_237113_((String)("[" + from + "," + to + "]"));
        }
        if (from == to) {
            return Component.m_237113_((String)("{" + from + "}"));
        }
        if (from > Integer.MIN_VALUE) {
            return Component.m_237113_((String)("[" + from + ",...)"));
        }
        if (to < Integer.MAX_VALUE) {
            return Component.m_237113_((String)("(...," + to + "]"));
        }
        return null;
    }
}

