/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.platform.Codecs;

public record CardUiTemplate(Integer[] effectColors, Integer[] effectDurations, Supplier<SoundEvent> flipSoundRef) {
    public static final CardUiTemplate TEMPLATE = new CardUiTemplate(new Integer[]{65280}, new Integer[]{5}, SoundRegistry.FLIP_COMMON);
    public static final Codec<CardUiTemplate> CODEC = Codecs.validate(RecordCodecBuilder.create(instance -> instance.group((App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectColors", (Object)TEMPLATE.effectColors()).forGetter(t -> t.effectColors), (App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectDurations", (Object)TEMPLATE.effectDurations()).forGetter(t -> t.effectDurations), (App)Codecs.supplier(BuiltInRegistries.f_256894_.m_194605_()).optionalFieldOf("flipSound", TEMPLATE.flipSoundRef()).forGetter(t -> t.flipSoundRef)).apply((Applicative)instance, CardUiTemplate::new)), template -> template.effectColors().length == template.effectDurations().length ? DataResult.success((Object)template) : DataResult.error(() -> "Effect duration count has to be the same as effect colors"));
    public static final Component DEFAULT_CARD_INFO_HEADER = Component.m_237115_((String)"collectorsalbum.tooltip.card.header").m_130940_(ChatFormatting.GRAY);
    public static final String ITEM_TOOLTIP_NUMBER_KEY = "collectorsalbum.tooltip.card.number";
    public static final String ITEM_TOOLTIP_CATEGORY_KEY = "collectorsalbum.tooltip.card.category";
    public static final String ITEM_TOOLTIP_RARITY_KEY = "collectorsalbum.tooltip.card.rarity";
    public static final String ITEM_TOOLTIP_VALUE_KEY = "collectorsalbum.tooltip.card.value";

    public static MutableComponent getCardNumberTooltip(Component numberLabel) {
        return Component.m_237110_((String)ITEM_TOOLTIP_NUMBER_KEY, (Object[])new Object[]{numberLabel}).m_130940_(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardNumberTooltip(int number) {
        MutableComponent label = Component.m_237113_((String)("#" + number)).m_130940_(ChatFormatting.YELLOW);
        return CardUiTemplate.getCardNumberTooltip((Component)label);
    }

    public static MutableComponent getCardCategoryTooltip(AlbumCard card) {
        return CardUiTemplate.getCardCategoryTooltip(card.getLinkedCategory());
    }

    public static MutableComponent getCardCategoryTooltip(AlbumCategory category) {
        return CardUiTemplate.getCardCategoryTooltip(category.getDisplayText());
    }

    public static MutableComponent getCardCategoryTooltip(Component categoryLabel) {
        return Component.m_237110_((String)ITEM_TOOLTIP_CATEGORY_KEY, (Object[])new Object[]{categoryLabel}).m_130940_(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardRarityTooltip(CardRarity rarity) {
        return CardUiTemplate.getCardRarityTooltip(rarity.getDisplayText());
    }

    public static MutableComponent getCardRarityTooltip(Component rarityLabel) {
        return Component.m_237110_((String)ITEM_TOOLTIP_RARITY_KEY, (Object[])new Object[]{rarityLabel}).m_130940_(ChatFormatting.GRAY);
    }

    public static MutableComponent getCardPointsTooltip(AlbumCard card) {
        return CardUiTemplate.getCardPointsTooltip(card.getPoints());
    }

    public static MutableComponent getCardPointsTooltip(int points) {
        MutableComponent label = Component.m_237110_((String)"collectorsalbum.text.points.value", (Object[])new Object[]{points}).m_130940_(ChatFormatting.YELLOW);
        return CardUiTemplate.getCardPointsTooltip((Component)label);
    }

    public static MutableComponent getCardPointsTooltip(Component pointsLabel) {
        return Component.m_237110_((String)ITEM_TOOLTIP_VALUE_KEY, (Object[])new Object[]{pointsLabel}).m_130940_(ChatFormatting.GRAY);
    }
}

