/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.card.CardFilter;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public interface AlbumCard
extends Comparable<AlbumCard>,
Predicate<CardFilter> {
    public ResourceLocation identifier();

    public ResourceLocation category();

    public CardUiTemplate template();

    public ItemStack asItem();

    public int getPoints();

    public int cardNumber();

    public void appendItemStackHoverTooltip(ItemStack var1, List<Component> var2, TooltipFlag var3);

    @Override
    default public int compareTo(@NotNull AlbumCard o) {
        return this.getPoints() - o.getPoints();
    }

    public AlbumCardType<?> getType();

    default public AlbumCategory getLinkedCategory() {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        return manager.findById(this.category()).orElseThrow();
    }
}

