/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.platform.Codecs;

public final class Album
implements Predicate<Album> {
    public static final Codec<ItemStack> NULLABLE_ITEMSTACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("id").forGetter(ItemStack::m_220173_), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.m_41783_()))).apply((Applicative)instance, (holder, count, optTag) -> {
        ItemStack itemStack = new ItemStack(holder, count.intValue());
        optTag.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
        return itemStack;
    }));
    public static final String NBT_ALBUM_PATH = "collectorsalbum:album";
    public static final Codec<Album> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.UUID_CODEC.fieldOf("albumId").forGetter(t -> t.albumId), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, Codecs.setCodec(AlbumCardManager.BY_NAME_CODEC)).xmap(HashMap::new, map -> map).fieldOf("cardsByCategory").forGetter(t -> (HashMap)t.cardsByCategory), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, Codecs.nonNullListCodec(NULLABLE_ITEMSTACK_CODEC, ItemStack.f_41583_)).fieldOf("categoryInventories").forGetter(t -> t.categoryInventories)).apply((Applicative)instance, Album::new));
    private final UUID albumId;
    private final Map<ResourceLocation, Set<AlbumCard>> cardsByCategory;
    private final Map<ResourceLocation, NonNullList<ItemStack>> categoryInventories;
    private final int points;

    private Album(Mutable mutable) {
        this.albumId = UUID.randomUUID();
        this.cardsByCategory = new HashMap<ResourceLocation, Set<AlbumCard>>();
        this.categoryInventories = new HashMap<ResourceLocation, NonNullList<ItemStack>>();
        int pointCounter = 0;
        AlbumCardManager manager = AlbumCardManager.getInstance();
        for (Map.Entry<ResourceLocation, NonNullList<ItemStack>> entry : mutable.inventories.entrySet()) {
            ResourceLocation key = entry.getKey();
            NonNullList<ItemStack> inventory = entry.getValue();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack itemStack = (ItemStack)inventory.get(i);
                if (itemStack.m_41619_()) continue;
                AlbumCard card = manager.getCardInfo(itemStack.m_41720_()).orElseThrow(() -> new IllegalArgumentException(String.format("Attempting to save undefined card for item %s into album", itemStack)));
                this.cardsByCategory.computeIfAbsent(key, t -> new HashSet()).add(card);
                this.categoryInventories.computeIfAbsent(key, t -> NonNullList.m_122780_((int)inventory.size(), (Object)ItemStack.f_41583_)).set(i, (Object)itemStack.m_41777_());
                pointCounter += card.getPoints();
            }
        }
        this.points = pointCounter;
    }

    private Album(UUID albumId) {
        this(albumId, new HashMap<ResourceLocation, Set<AlbumCard>>(), new HashMap<ResourceLocation, NonNullList<ItemStack>>());
    }

    private Album(UUID albumId, Map<ResourceLocation, Set<AlbumCard>> cardsByCategory, Map<ResourceLocation, NonNullList<ItemStack>> categoryInventories) {
        this.albumId = albumId;
        this.cardsByCategory = cardsByCategory;
        this.categoryInventories = categoryInventories;
        this.points = cardsByCategory.values().stream().flatMap(Collection::stream).mapToInt(AlbumCard::getPoints).sum();
    }

    public static Album emptyAlbum() {
        return new Album(UUID.randomUUID());
    }

    public static Album get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(NBT_ALBUM_PATH, 10)) {
            return Album.emptyAlbum();
        }
        CompoundTag albumTag = tag.m_128469_(NBT_ALBUM_PATH);
        DataResult result = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)albumTag);
        return result.result().orElseGet(Album::emptyAlbum);
    }

    public static void set(ItemStack stack, Album album) {
        if (album == null && stack.m_41783_() != null && stack.m_41783_().m_128425_(NBT_ALBUM_PATH, 10)) {
            stack.m_41783_().m_128473_(NBT_ALBUM_PATH);
            return;
        }
        CompoundTag tag = stack.m_41784_();
        DataResult dataResult = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)album);
        Tag result = dataResult.result().orElse(null);
        if (result instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)result;
            tag.m_128365_(NBT_ALBUM_PATH, (Tag)compoundTag);
        }
    }

    @Override
    public boolean test(Album album) {
        return album != null && this.albumId.equals(album.albumId);
    }

    public int getPoints() {
        return this.points;
    }

    public NonNullList<ItemStack> getInventory(ResourceLocation category) {
        return this.categoryInventories.getOrDefault(category, (NonNullList<ItemStack>)NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_));
    }

    public Collection<AlbumCard> getCardsForCategory(ResourceLocation category) {
        Set<AlbumCard> cards = this.cardsByCategory.get(category);
        return cards == null ? Collections.emptyList() : cards;
    }

    public int countCards() {
        return this.cardsByCategory.values().stream().mapToInt(Set::size).sum();
    }

    public Map<CardRarity, CardRarityStatistics> calculateRarityRatios() {
        List<RarityHolder> rarityCards = this.cardsByCategory.values().stream().flatMap(Collection::stream).filter(card -> card instanceof RarityHolder).map(card -> (RarityHolder)card).toList();
        EnumMap<CardRarity, CardRarityStatistics> map = new EnumMap<CardRarity, CardRarityStatistics>(CardRarity.class);
        Map<CardRarity, List<RarityHolder>> byRarity = rarityCards.stream().collect(Collectors.groupingBy(RarityHolder::rarity));
        int totalCards = Math.max(rarityCards.size(), 1);
        for (CardRarity rarity : CardRarity.values()) {
            List list = byRarity.getOrDefault((Object)rarity, Collections.emptyList());
            CardRarityStatistics statistics = new CardRarityStatistics(list.size(), totalCards);
            map.put(rarity, statistics);
        }
        return map;
    }

    public List<AlbumCategoryStatistics> calculateStatistics() {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        Collection<AlbumCategory> categories = manager.listCategories();
        return categories.stream().map(cat -> {
            Set cardsInCategory = this.cardsByCategory.getOrDefault(cat.identifier(), Collections.emptySet());
            int categoryTotal = cat.getCardNumbers().length;
            int categoryCollected = cardsInCategory.size();
            return new AlbumCategoryStatistics((AlbumCategory)cat, categoryCollected, categoryTotal);
        }).filter(stat -> stat.allCards() > 0).sorted(Comparator.comparingDouble(AlbumCategoryStatistics::getCollectedProgress).reversed()).toList();
    }

    public void tick(Player player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.applyBonuses(context);
    }

    public void removed(Player player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.removeBonuses(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Album album = (Album)o;
        return Objects.equals(this.albumId, album.albumId);
    }

    public int hashCode() {
        return Objects.hashCode(this.albumId);
    }

    public static final class Mutable {
        private final Map<ResourceLocation, NonNullList<ItemStack>> inventories;

        public Mutable(Album album) {
            HashMap<ResourceLocation, NonNullList<ItemStack>> inventories = new HashMap<ResourceLocation, NonNullList<ItemStack>>();
            for (Map.Entry<ResourceLocation, NonNullList<ItemStack>> entry : album.categoryInventories.entrySet()) {
                ResourceLocation key = entry.getKey();
                NonNullList<ItemStack> categoryInventory = entry.getValue();
                AlbumCategoryManager.getInstance().findById(key).ifPresent(category -> {
                    NonNullList inventory = NonNullList.m_122780_((int)category.getCardNumbers().length, (Object)ItemStack.f_41583_);
                    for (int i = 0; i < categoryInventory.size(); ++i) {
                        ItemStack itemStack = (ItemStack)categoryInventory.get(i);
                        if (itemStack.m_41619_()) continue;
                        inventory.set(i, (Object)itemStack.m_41777_());
                    }
                    inventories.put(key, inventory);
                });
            }
            this.inventories = inventories;
        }

        public void set(ResourceLocation category, int index, ItemStack itemStack) {
            NonNullList inventory = this.inventories.get(category);
            if (inventory == null) {
                AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
                AlbumCategory albumCategory = manager.findById(category).orElseThrow(() -> new IllegalArgumentException(String.format("Attempting to insert item %s into unknown category %s", itemStack, category)));
                inventory = NonNullList.m_122780_((int)albumCategory.getCardNumbers().length, (Object)ItemStack.f_41583_);
                this.inventories.put(category, (NonNullList<ItemStack>)inventory);
            }
            inventory.set(index, (Object)itemStack.m_41777_());
        }

        public Album toImmutable() {
            return new Album(this);
        }

        public String toString() {
            return "MutableAlbum{inventories=" + this.inventories + "}";
        }
    }

    public record CardRarityStatistics(int collected, int total) {
        public float getRatio() {
            return this.total > 0 ? (float)this.collected / (float)this.total : 0.0f;
        }
    }

    public record AlbumCategoryStatistics(AlbumCategory category, int collectedCards, int allCards) {
        public float getCollectedProgress() {
            return this.allCards > 0 ? (float)this.collectedCards / (float)this.allCards : 0.0f;
        }
    }
}

