/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.network.C2S_CompleteOpeningCardPack;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CardPackOpeningScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"screen.collectorsalbum.card_pack_opening_screen");
    private static final ResourceLocation CARD_BG = new ResourceLocation("collectorsalbum", "textures/ui/card_back.png");
    private static final int CARD_SIZE = 32;
    private static final int CARD_MARGIN = 8;
    private final FxEmitter emitter;
    private final List<ItemStack> drops;
    private final List<CardWidget> cardWidgets = new ArrayList<CardWidget>();

    public CardPackOpeningScreen(List<ItemStack> drops) {
        super(TITLE);
        this.emitter = new FxEmitter();
        this.drops = drops;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.cardWidgets.clear();
        int rows = Mth.m_14167_((float)((float)this.drops.size() / 6.0f));
        int containerHeight = rows * 40 - 8;
        int containerTop = (this.f_96544_ - containerHeight) / 2;
        for (int y = 0; y < rows; ++y) {
            int rowCols = Math.min(6, this.drops.size() - y * 6);
            int rowWidth = rowCols * 40 - 8;
            int rowLeft = (this.f_96543_ - rowWidth) / 2;
            int rowTop = containerTop + y * 40;
            for (int x = 0; x < rowCols; ++x) {
                int index = x + y * 6;
                ItemStack drop = this.drops.get(index);
                CardWidget widget = this.addCardWidget(rowLeft + x * 40, rowTop, drop);
                widget.setOnIconFlipped(this::onCardFlipped);
                widget.setPositionAnimationDelay(index * 3);
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        this.emitter.draw(graphics, delta);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public void m_7861_() {
        PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_CompleteOpeningCardPack());
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.emitter.update();
        this.cardWidgets.forEach(CardWidget::tick);
    }

    private void onCardFlipped(CardWidget widget) {
        AlbumCard card = widget.card;
        CardUiTemplate template = card.template();
        Integer[] effects = template.effectColors();
        Integer[] durations = template.effectDurations();
        double speed = 4.0;
        int count = Math.min(20 + card.getPoints() * 5, 100) / Math.max(effects.length, 1);
        for (int i = 0; i < effects.length; ++i) {
            float centerX = (float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f;
            float centerY = (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f;
            this.emitter.emit(centerX, centerY, effects[i], durations[i], count, speed);
        }
    }

    private CardWidget addCardWidget(int x, int y, ItemStack itemStack) {
        int left = (this.f_96543_ - 32) / 2;
        int top = this.f_96544_ - 16;
        CardWidget widget = new CardWidget(left, top, 32, 32, x, y, itemStack);
        this.cardWidgets.add(widget);
        return (CardWidget)this.m_142416_((GuiEventListener)widget);
    }

    static void renderFullTexture(ResourceLocation path, Matrix4f pose, float x, float y, float z, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_252986_(pose, x, y, z).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose, x, y + height, z).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, x + width, y + height, z).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_252986_(pose, x + width, y, z).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    static void renderFullColoredTexture(ResourceLocation path, Matrix4f pose, float x, float y, float z, float width, float height, int color) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        builder.m_252986_(pose, x, y, z).m_7421_(0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(pose, x, y + height, z).m_7421_(0.0f, 1.0f).m_193479_(color).m_5752_();
        builder.m_252986_(pose, x + width, y + height, z).m_7421_(1.0f, 1.0f).m_193479_(color).m_5752_();
        builder.m_252986_(pose, x + width, y, z).m_7421_(1.0f, 0.0f).m_193479_(color).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    private static class FxEmitter {
        private final List<FxElement> liveElements = new ArrayList<FxElement>();

        private FxEmitter() {
        }

        void emit(float x, float y, int color, int lifetime, int count, double dirMul) {
            for (int i = 0; i < count; ++i) {
                FxElement element = new FxElement(x, y, color, lifetime);
                double xRand = Math.random() - Math.random();
                double yRand = Math.random() - Math.random();
                element.setDir(new Vector2d(xRand * dirMul, yRand * dirMul));
                this.liveElements.add(element);
            }
        }

        void update() {
            Iterator<FxElement> it = this.liveElements.iterator();
            while (it.hasNext()) {
                FxElement element = it.next();
                element.update();
                if (!element.shouldRemove()) continue;
                it.remove();
            }
        }

        void draw(GuiGraphics graphics, float delta) {
            this.liveElements.forEach(fx -> fx.draw(graphics, delta));
        }
    }

    private static final class CardWidget
    extends AbstractWidget {
        private static final int TOTAL_MOVE_TIME = 10;
        private static final int TOTAL_FLIP_TIME = 20;
        private final int originalX;
        private final int originalY;
        private final int targetX;
        private final int targetY;
        private final AlbumCard card;
        private final ResourceLocation itemTexture;
        private Consumer<CardWidget> onIconFlipped;
        private Consumer<CardWidget> onFlipFinish;
        private boolean flipped;
        private boolean flipping;
        private int flipCurrent;
        private int flipOld;
        private int positionCurrent;
        private int positionOld;
        private int positionAnimationDelay;

        public CardWidget(int x, int y, int width, int height, int targetX, int targetY, ItemStack itemStack) {
            super(x, y, width, height, CommonComponents.f_237098_);
            this.originalX = x;
            this.originalY = y;
            this.targetX = targetX;
            this.targetY = targetY;
            this.card = AlbumCardManager.getInstance().getCardInfo(itemStack.m_41720_()).orElse(null);
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            this.itemTexture = new ResourceLocation(itemId.m_135827_(), "textures/item/" + itemId.m_135815_() + ".png");
        }

        public void setOnIconFlipped(Consumer<CardWidget> onIconFlipped) {
            this.onIconFlipped = onIconFlipped;
        }

        public void setOnFlipFinish(Consumer<CardWidget> onFlipFinish) {
            this.onFlipFinish = onFlipFinish;
        }

        public void setPositionAnimationDelay(int positionAnimationDelay) {
            this.positionAnimationDelay = positionAnimationDelay;
        }

        public void tick() {
            this.tickPosition();
            this.tickFlipping();
        }

        public void m_7435_(SoundManager manager) {
            SoundEvent event;
            AlbumCard albumCard = this.card;
            if (albumCard instanceof RarityHolder) {
                RarityHolder holder = (RarityHolder)albumCard;
                CardRarity rarity = holder.rarity();
                event = rarity.getFlipSoundRef().get();
            } else {
                event = (SoundEvent)SoundRegistry.FLIP_COMMON.get();
            }
            manager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
        }

        public void m_5716_(double $$0, double $$1) {
            if (this.flipping || this.flipped) {
                return;
            }
            this.flipping = true;
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float deltaTicks) {
            this.updatePosition(deltaTicks);
            this.renderCardWithFlipAnimation(graphics, deltaTicks);
        }

        private void updatePosition(float delta) {
            if (this.positionOld == this.positionCurrent && this.positionCurrent > 0) {
                this.m_252865_(this.targetX);
                this.m_253211_(this.targetY);
                return;
            }
            float positionAnimProgress = Mth.m_14179_((float)delta, (float)this.positionOld, (float)this.positionCurrent) / 10.0f;
            float positionAnimEased = 1.0f - (float)Math.pow(1.0f - positionAnimProgress, 3.0);
            int xDelta = this.targetX - this.originalX;
            int yDelta = this.targetY - this.originalY;
            this.m_252865_((int)((float)this.originalX + (float)xDelta * positionAnimEased));
            this.m_253211_((int)((float)this.originalY + (float)yDelta * positionAnimEased));
        }

        private void renderCardWithFlipAnimation(GuiGraphics graphics, float delta) {
            float px = this.m_252754_();
            int py = this.m_252907_();
            float pWidth = this.m_5711_();
            int pHeight = this.m_93694_();
            if (this.flipping) {
                float flipProgress;
                boolean wasFlipped = this.flipped;
                float flipOld = (float)this.flipOld / 20.0f;
                float flipActual = (float)this.flipCurrent / 20.0f;
                float flipProgressRaw = Mth.m_14179_((float)delta, (float)flipOld, (float)flipActual);
                float f = flipProgress = (double)flipProgressRaw < 0.5 ? 4.0f * flipProgressRaw * flipProgressRaw * flipProgressRaw : 1.0f - (float)Math.pow(-2.0f * flipProgressRaw + 2.0f, 3.0) / 2.0f;
                if ((double)flipProgress >= 0.5) {
                    this.flipped = true;
                }
                float amount = this.flipped ? (flipProgress - 0.5f) / 0.5f : 1.0f - flipProgress / 0.5f;
                float halfWidth = (float)this.m_5711_() / 2.0f;
                px = (float)this.m_252754_() + halfWidth * (1.0f - amount);
                pWidth = (float)this.m_5711_() * amount;
                if (this.flipped && !wasFlipped && this.onIconFlipped != null && this.card != null) {
                    this.onIconFlipped.accept(this);
                }
            }
            ResourceLocation texture = this.flipped ? this.itemTexture : CARD_BG;
            Matrix4f poseMat = graphics.m_280168_().m_85850_().m_252922_();
            CardPackOpeningScreen.renderFullTexture(texture, poseMat, px, py, 400.0f, pWidth, pHeight);
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return !this.flipped && !this.flipping && super.m_93680_(mouseX, mouseY);
        }

        private void tickPosition() {
            if (this.positionAnimationDelay > 0) {
                --this.positionAnimationDelay;
                return;
            }
            this.positionOld = this.positionCurrent;
            if (this.positionCurrent < 10 && this.positionCurrent++ == 0) {
                SoundManager manager = Minecraft.m_91087_().m_91106_();
                manager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundRegistry.FLIP_COMMON.get()), (float)1.5f, (float)0.25f));
            }
        }

        private void tickFlipping() {
            if (!this.flipping) {
                return;
            }
            this.flipOld = this.flipCurrent;
            if (this.flipCurrent >= 20) {
                this.flipping = false;
                if (this.onFlipFinish != null && this.card != null) {
                    this.onFlipFinish.accept(this);
                }
                return;
            }
            ++this.flipCurrent;
        }
    }

    private static class FxElement {
        private static final ResourceLocation[] PATHS = new ResourceLocation[]{FxElement.spark(0), FxElement.spark(1), FxElement.spark(2), FxElement.spark(3), FxElement.spark(4), FxElement.spark(5), FxElement.spark(6), FxElement.spark(7)};
        private float x;
        private float y;
        private float xOld;
        private float yOld;
        private final int color;
        private final int stageLife;
        private int stage;
        private int stageLifeLeft;
        private Vector2d direction;

        public FxElement(float x, float y, int color, int stageLife) {
            this.x = x;
            this.y = y;
            this.xOld = x;
            this.yOld = y;
            this.color = color;
            this.stageLife = stageLife;
            this.stageLifeLeft = stageLife;
            this.stage = PATHS.length - 1;
        }

        void draw(GuiGraphics graphics, float delta) {
            ResourceLocation path = PATHS[this.stage];
            Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
            float scale = 8.0f;
            float halfScale = scale / 2.0f;
            float xPos = Mth.m_14179_((float)delta, (float)this.xOld, (float)this.x);
            float yPos = Mth.m_14179_((float)delta, (float)this.yOld, (float)this.y);
            CardPackOpeningScreen.renderFullColoredTexture(path, pose, xPos - halfScale, yPos - halfScale, 0.0f, scale, scale, 0xFF000000 | this.color);
        }

        void update() {
            this.xOld = this.x;
            this.yOld = this.y;
            if (--this.stageLifeLeft < 0) {
                --this.stage;
                this.stageLifeLeft = this.stageLife;
            }
            if (this.direction != null) {
                this.x += (float)this.direction.x;
                this.y += (float)this.direction.y;
                this.direction.mul((double)0.95f);
            }
        }

        void setDir(Vector2d dir) {
            this.direction = dir;
        }

        boolean shouldRemove() {
            return this.stage == 0 && this.stageLifeLeft <= 0;
        }

        private static ResourceLocation spark(int index) {
            return new ResourceLocation(String.format("textures/particle/spark_%d.png", index));
        }
    }
}

