/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import team.tnt.collectorsalbum.client.screen.AlbumBonusesScreen;
import team.tnt.collectorsalbum.client.screen.AlbumCategoryScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.client.screen.LabelRenderable;
import team.tnt.collectorsalbum.client.screen.LabelWidget;
import team.tnt.collectorsalbum.client.screen.TextureRenderable;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.item.AlbumItem;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class AlbumMainPageScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"screen.collectorsalbum.album.main").m_130940_(ChatFormatting.BOLD);
    public static final ResourceLocation BACKGROUND = new ResourceLocation("collectorsalbum", "textures/ui/album.png");
    public static final int TEXT_COLOR = 8084556;
    private static final Component LABEL_RARITIES = Component.m_237115_((String)"collectorsalbum.text.statistics.rarities_label").m_130940_(ChatFormatting.UNDERLINE);
    private static final Component LABEL_CATEGORIES = Component.m_237115_((String)"collectorsalbum.text.statistics.categories_label").m_130940_(ChatFormatting.UNDERLINE);
    private static final String LANG_KEY_COLLECTED = "collectorsalbum.text.statistics.collected";
    private static final String LANG_KEY_POINTS = "collectorsalbum.text.statistics.points";
    private final ItemStack itemStack;
    protected int textureWidth = 256;
    protected int textureHeight = 256;
    protected int left;
    protected int top;

    AlbumMainPageScreen(ItemStack itemStack) {
        super(TITLE);
        this.itemStack = itemStack;
    }

    public static List<BookmarkWidget> getBookmarks(int guiWidth, int guiHeight, int albumWidth, int albumHeight, int bookImageHeight) {
        int left = (guiWidth - albumWidth) / 2;
        int top = (guiHeight - albumHeight) / 2 + 10;
        int right = left + albumWidth;
        int tooltipDelay = 1000;
        ArrayList<BookmarkWidget> bookmarks = new ArrayList<BookmarkWidget>();
        BookmarkWidget home = new BookmarkWidget(left - 32, top, 32, 18, true, ((AlbumItem)((Object)ItemRegistry.ALBUM.get())).m_7968_(), () -> Minecraft.m_91087_().f_91080_ instanceof AlbumMainPageScreen);
        home.m_257544_(Tooltip.m_257550_((Component)TITLE));
        home.m_257427_(tooltipDelay);
        home.setAction(AlbumNavigationHelper::navigateHomepage);
        BookmarkWidget bonuses = new BookmarkWidget(left - 32, top + 20, 32, 18, true, Items.f_42616_.m_7968_(), () -> Minecraft.m_91087_().f_91080_ instanceof AlbumBonusesScreen);
        bonuses.m_257544_(Tooltip.m_257550_((Component)AlbumBonusesScreen.TITLE));
        bonuses.m_257427_(tooltipDelay);
        bonuses.setAction(AlbumNavigationHelper::navigateBonusesPage);
        bookmarks.add(home);
        bookmarks.add(bonuses);
        List<AlbumCategory> categories = AlbumNavigationHelper.listCategoriesForBookmarks(bookImageHeight - 20);
        int index = 0;
        for (AlbumCategory category : categories) {
            BookmarkWidget categoryBookmark = new BookmarkWidget(right, top + index++ * 20, 32, 18, false, category.visualTemplate().bookmarkIcon, () -> {
                AlbumCategoryScreen catScreen;
                Screen patt3672$temp = Minecraft.m_91087_().f_91080_;
                return patt3672$temp instanceof AlbumCategoryScreen && (catScreen = (AlbumCategoryScreen)patt3672$temp).getCategory().identifier().equals((Object)category.identifier());
            });
            categoryBookmark.m_257544_(Tooltip.m_257550_((Component)category.getDisplayText()));
            categoryBookmark.m_257427_(tooltipDelay);
            categoryBookmark.setAction(() -> AlbumNavigationHelper.navigateCategory(category));
            bookmarks.add(categoryBookmark);
        }
        return bookmarks;
    }

    public void m_7861_() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        this.left = (this.f_96543_ - this.textureWidth) / 2;
        this.top = (this.f_96544_ - this.textureHeight) / 2;
        this.addDefaultWidgets();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    protected void addDefaultWidgets() {
        List<BookmarkWidget> bookmarks = AlbumMainPageScreen.getBookmarks(this.f_96543_, this.f_96544_, this.textureWidth, this.textureHeight, 180);
        for (BookmarkWidget bookmark : bookmarks) {
            this.m_142416_((GuiEventListener)bookmark);
        }
        this.m_169394_(new TextureRenderable(BACKGROUND, this.left, this.top, this.textureWidth, this.textureHeight));
        int titleWidth = this.f_96547_.m_92852_((FormattedText)TITLE);
        this.m_169394_(new LabelRenderable(TITLE, this.left + (128 - titleWidth) / 2, this.top + 14, 8084556));
        Album album = Album.get(this.itemStack);
        if (album == null) {
            return;
        }
        AlbumCategoryManager categoryManager = AlbumCategoryManager.getInstance();
        int collected = album.countCards();
        int available = categoryManager.getCollectibleCardCount();
        MutableComponent percent = Component.m_237113_((String)String.format(Locale.ROOT, "(%.1f%%)", Float.valueOf((float)collected / (float)available * 100.0f)));
        MutableComponent collectedCards = Component.m_237110_((String)LANG_KEY_COLLECTED, (Object[])new Object[]{collected, available});
        this.m_169394_(new LabelRenderable((Component)collectedCards, this.left + 17, this.top + 30, 8084556));
        this.m_169394_(new LabelRenderable((Component)percent, this.left + 17 + this.f_96547_.m_92852_((FormattedText)collectedCards) - this.f_96547_.m_92852_((FormattedText)percent), this.top + 40, 8084556));
        Map<CardRarity, Album.CardRarityStatistics> ratios = album.calculateRarityRatios();
        this.m_169394_(new LabelRenderable(LABEL_RARITIES, this.left + 17, this.top + 55, 8084556));
        int rarityIndex = 0;
        for (CardRarity rarity : CardRarity.values()) {
            Album.CardRarityStatistics statistics = ratios.get((Object)rarity);
            MutableComponent rarityText = Component.m_237113_((String)rarity.getDisplayText().getString());
            rarityText.m_7383_().m_131152_(new ChatFormatting[]{ChatFormatting.RESET});
            String ratio = String.format(Locale.ROOT, "%.1f%%", Float.valueOf(statistics.getRatio() * 100.0f));
            MutableComponent label = Component.m_237113_((String)(rarityText.getString() + ": " + ratio));
            LabelWidget labelWidget = (LabelWidget)this.m_142416_((GuiEventListener)new LabelWidget(this.left + 20, this.top + 65 + rarityIndex++ * 10, this.f_96547_.m_92852_((FormattedText)label), 10, (Component)label, this.f_96547_, 8084556));
            labelWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)(statistics.collected() + "/" + statistics.total())).m_130940_(ChatFormatting.GREEN)));
        }
        MutableComponent points = Component.m_237113_((String)String.valueOf(album.getPoints())).m_130938_(st -> st.m_178520_(-1069568)).m_130940_(ChatFormatting.BOLD);
        MutableComponent pointsLabel = Component.m_237110_((String)LANG_KEY_POINTS, (Object[])new Object[]{points}).m_130938_(st -> st.m_178520_(8084556));
        this.m_169394_(new LabelRenderable((Component)pointsLabel, this.left + 145, this.top + 14, false, 0xFFFFFF));
        this.m_169394_(new LabelRenderable(LABEL_CATEGORIES, this.left + 145, this.top + 30, false, 8084556));
        List<Album.AlbumCategoryStatistics> statistics = album.calculateStatistics();
        for (int i = 0; i < Math.min(12, statistics.size()); ++i) {
            Album.AlbumCategoryStatistics stat = statistics.get(i);
            MutableComponent categoryLabelNoStyle = Component.m_237113_((String)stat.category().getDisplayText().getString());
            categoryLabelNoStyle.m_7383_().m_131152_(new ChatFormatting[]{ChatFormatting.RESET});
            MutableComponent displayLabel = Component.m_237113_((String)(categoryLabelNoStyle.getString() + ": " + stat.collectedCards() + "/" + stat.allCards()));
            LabelWidget labelWidget = (LabelWidget)this.m_142416_((GuiEventListener)new LabelWidget(this.left + 148, this.top + 40 + i * 10, 95, 10, (Component)displayLabel, this.f_96547_, 8084556));
            labelWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)String.format(Locale.ROOT, "%.1f%%", Float.valueOf(stat.getCollectedProgress() * 100.0f))).m_130940_(ChatFormatting.GREEN)));
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCategory category = manager.getCategoryForPage(0);
        if (category != null) {
            PageButton button = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.left + 210, this.top + 156, true, btn -> AlbumNavigationHelper.navigateNextCategory(), true));
            button.m_257544_(Tooltip.m_257550_((Component)AlbumNavigationHelper.getNextCategoryTitle()));
            button.m_257427_(1000);
        }
    }
}

