/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import team.tnt.collectorsalbum.client.screen.AlbumMainPageScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryUiTemplate;
import team.tnt.collectorsalbum.common.menu.AlbumCategoryMenu;

public class AlbumCategoryScreen
extends AbstractContainerScreen<AlbumCategoryMenu> {
    private final AlbumCategory category;
    private final List<Slot> cardSlots;

    public AlbumCategoryScreen(AlbumCategoryMenu menu, Inventory inventory, Component title, AlbumCategory category) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.category = category;
        AlbumCategoryUiTemplate template = category.visualTemplate();
        this.f_97726_ = template.backgroundTexture.textureWidth();
        this.f_97727_ = template.backgroundTexture.textureHeight();
        this.cardSlots = menu.f_38839_.stream().filter(slot -> !(slot.f_40218_ instanceof Inventory)).toList();
    }

    public AlbumCategory getCategory() {
        return this.category;
    }

    protected void m_7856_() {
        super.m_7856_();
        AlbumNavigationHelper.restoreMousePositionFromSnapshot();
        PageButton prevPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.f_97735_ + 22, this.f_97736_ + 156, false, btn -> AlbumNavigationHelper.navigatePreviousCategory(), true));
        prevPage.m_257544_(Tooltip.m_257550_((Component)AlbumNavigationHelper.getPreviousCategoryTitle()));
        prevPage.m_257427_(1000);
        if (AlbumNavigationHelper.hasNextCategory()) {
            PageButton nextPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.f_97735_ + 210, this.f_97736_ + 156, true, btn -> AlbumNavigationHelper.navigateNextCategory(), true));
            nextPage.m_257544_(Tooltip.m_257550_((Component)AlbumNavigationHelper.getNextCategoryTitle()));
            nextPage.m_257427_(1000);
        }
        AlbumCategoryUiTemplate template = this.category.visualTemplate();
        AlbumMainPageScreen.getBookmarks(this.f_96543_, this.f_96544_, this.f_97726_, this.f_97727_, template.bookImageHeight).forEach(x$0 -> {
            BookmarkWidget cfr_ignored_0 = (BookmarkWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void m_7861_() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
        super.m_7861_();
    }

    protected void m_280003_(GuiGraphics graphics, int $$1, int $$2) {
        int width = this.f_96547_.m_92852_((FormattedText)this.category.getDisplayText());
        graphics.m_280614_(this.f_96547_, this.category.getDisplayText(), (this.f_97726_ - width) / 2, -15, 0xFFFFFF, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float v, int i, int i1) {
        AlbumCategoryUiTemplate template = this.category.visualTemplate();
        AlbumCategoryScreen.blitTextureTemplate(guiGraphics, this.f_97735_, this.f_97736_, template.backgroundTexture);
        int[] cardNumbers = this.category.getCardNumbers();
        if (template.renderSlots) {
            for (int slot = 0; slot < this.cardSlots.size(); ++slot) {
                Slot cardSlot = this.cardSlots.get(slot);
                AlbumCategoryScreen.blitTextureTemplate(guiGraphics, this.f_97735_ + cardSlot.f_40220_ - 1, this.f_97736_ + cardSlot.f_40221_ - 1, template.slotTexture);
                if (!template.renderSlotCardNumbers || cardSlot.m_6657_()) continue;
                MutableComponent num = Component.m_237113_((String)("#" + cardNumbers[slot]));
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)(this.f_97735_ + cardSlot.f_40220_ + 1), (float)(this.f_97736_ + cardSlot.f_40221_ + 1), 0.0f);
                pose.m_85841_(0.75f, 0.75f, 0.75f);
                guiGraphics.m_280614_(this.f_96547_, (Component)num, 0, 0, template.slotCardNumberTextColor, false);
                pose.m_85849_();
            }
        }
    }

    public static void blitTextureTemplate(GuiGraphics graphics, int x, int y, AlbumCategoryUiTemplate.TextureTemplate template) {
        int texWidth = template.textureWidth();
        int texHeight = template.textureHeight();
        float u = (float)template.texU() / (float)texWidth;
        float v = (float)template.texV() / (float)texHeight;
        graphics.m_280398_(template.resource(), x, y, 0, u, v, template.width(), template.height(), texWidth, texHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }
}

