/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.client.screen.AlbumMainPageScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.client.screen.LabelRenderable;
import team.tnt.collectorsalbum.client.screen.LabelWidget;
import team.tnt.collectorsalbum.client.screen.TextureRenderable;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumBonusesScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"screen.collectorsalbum.album.bonuses").m_130940_(ChatFormatting.BOLD);
    private static final int LINE_COUNT = 14;
    private final ItemStack itemStack;
    private int left;
    private int top;
    private int scrollingOffset;
    private int pageSize;
    private int currentBonusIndex;

    public AlbumBonusesScreen(ItemStack itemStack) {
        super(TITLE);
        this.itemStack = itemStack;
    }

    public void m_7861_() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float renderTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, renderTick);
    }

    protected void m_7856_() {
        this.left = (this.f_96543_ - 256) / 2;
        this.top = (this.f_96544_ - 256) / 2;
        AlbumMainPageScreen.getBookmarks(this.f_96543_, this.f_96544_, 256, 256, 180).forEach(x$0 -> {
            BookmarkWidget cfr_ignored_0 = (BookmarkWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_169394_(new TextureRenderable(AlbumMainPageScreen.BACKGROUND, this.left, this.top, 256, 256));
        Album album = Album.get(this.itemStack);
        if (album == null) {
            MutableComponent error = Component.m_237113_((String)"Failed to load album!").m_130940_(ChatFormatting.RED);
            int n = this.left + (256 - this.f_96547_.m_92852_((FormattedText)error)) / 2;
            Objects.requireNonNull(this.f_96547_);
            this.m_169394_(new LabelRenderable((Component)error, n, this.top + (180 - 9) / 2));
            return;
        }
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        Pair<AlbumBonus, AlbumBonus> bonusPair = manager.getBonusesForPage(this.currentBonusIndex);
        ActionContext context = ActionContext.of("player", this.f_96541_.f_91074_, "album", album);
        List<AlbumBonusDescriptionOutput.ComponentWithTooltip> first = this.getBonusDescription((AlbumBonus)bonusPair.getFirst(), context);
        List<AlbumBonusDescriptionOutput.ComponentWithTooltip> second = this.getBonusDescription((AlbumBonus)bonusPair.getSecond(), context);
        this.pageSize = Math.max(first.size(), second.size());
        this.createWidgets(first, this.left + 14, this.top + 14, this.scrollingOffset);
        this.createWidgets(second, this.left + 142, this.top + 14, this.scrollingOffset);
        if (this.currentBonusIndex > 0) {
            PageButton prevPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.left + 22, this.top + 156, false, btn -> this.addPage(-1), true));
            prevPage.m_257544_(Tooltip.m_257550_((Component)AlbumNavigationHelper.getPreviousCategoryTitle()));
            prevPage.m_257427_(1000);
        }
        if (manager.hasNextPage(this.currentBonusIndex)) {
            PageButton nextPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.left + 210, this.top + 156, true, btn -> this.addPage(1), true));
            nextPage.m_257544_(Tooltip.m_257550_((Component)AlbumNavigationHelper.getNextCategoryTitle()));
            nextPage.m_257427_(1000);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        int scale = (int)(-scrollY);
        int next = this.scrollingOffset + scale;
        if (next >= 0 && next + 14 <= this.pageSize) {
            this.scrollingOffset = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    private void createWidgets(List<AlbumBonusDescriptionOutput.ComponentWithTooltip> components, int x, int y, int scroll) {
        int offsetStep = 2;
        for (int i = scroll; i < Math.min(scroll + 14, components.size()); ++i) {
            int index = i - scroll;
            AlbumBonusDescriptionOutput.ComponentWithTooltip component = components.get(i);
            int offset = offsetStep * component.level();
            Component label = component.label();
            LabelWidget widget = (LabelWidget)this.m_142416_((GuiEventListener)new LabelWidget(x + offset, y + index * 10, 100 - offset, 10, label, this.f_96547_, 8084556, true));
            if (!component.hasTooltip()) continue;
            widget.m_257544_(Tooltip.m_257550_((Component)component.tooltip()));
            widget.m_257427_(400);
        }
    }

    private List<AlbumBonusDescriptionOutput.ComponentWithTooltip> getBonusDescription(AlbumBonus bonus, ActionContext context) {
        AlbumBonusDescriptionOutput description = AlbumBonusDescriptionOutput.createEmpty(context);
        bonus.addDescription(description);
        return description.toComponentList();
    }

    private void addPage(int direction) {
        this.setPage(this.currentBonusIndex + direction);
    }

    private void setPage(int page) {
        this.currentBonusIndex = page;
        this.scrollingOffset = 0;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }
}

