/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum;

import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.client.CollectorsAlbumClient;
import team.tnt.collectorsalbum.common.init.AlbumBonusRegistry;
import team.tnt.collectorsalbum.common.init.BlockRegistry;
import team.tnt.collectorsalbum.common.init.CardTypeRegistry;
import team.tnt.collectorsalbum.common.init.CategoryRegistry;
import team.tnt.collectorsalbum.common.init.ItemDropProviderRegistry;
import team.tnt.collectorsalbum.common.init.ItemGroupRegistry;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.init.MenuRegistry;
import team.tnt.collectorsalbum.common.init.NumberProviderRegistry;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.MobAdditionalDropManager;
import team.tnt.collectorsalbum.platform.registration.ForgeRegistration;
import team.tnt.collectorsalbum.platform.resource.MenuScreenRegistration;

@Mod(value="collectorsalbum")
public class CollectorsAlbumForge {
    public CollectorsAlbumForge() {
        CollectorsAlbum.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeRegistration.subscribeRegistryEvent(eventBus, BlockRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, ItemRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, ItemGroupRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, CardTypeRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, CategoryRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, SoundRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, NumberProviderRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, ItemDropProviderRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, AlbumBonusRegistry.REGISTRY);
        ForgeRegistration.subscribeRegistryEvent(eventBus, MenuRegistry.REGISTRY);
        eventBus.addListener(this::createNewRegistries);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::addReloadListeners);
        forgeBus.addListener(this::playerTick);
        forgeBus.addListener(this::playerLoggedOut);
        forgeBus.addListener(this::serverStopping);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> CollectorsAlbumClient::construct);
    }

    private void setup(FMLCommonSetupEvent event) {
        CollectorsAlbum.NETWORK_MANAGER.bind(null);
        CollectorsAlbum.NETWORK_MANAGER.close();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CollectorsAlbumClient.init();
        event.enqueueWork(() -> MenuScreenRegistration.bind());
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        CollectorsAlbum.tickPlayer(event.player);
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CollectorsAlbum.playerLoggedOut(event.getEntity());
    }

    private void serverStopping(ServerStoppingEvent event) {
        CollectorsAlbum.serverStopped();
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AlbumCardManager.getInstance());
        event.addListener((PreparableReloadListener)AlbumCategoryManager.getInstance());
        event.addListener((PreparableReloadListener)AlbumBonusManager.getInstance());
        event.addListener((PreparableReloadListener)CardPackDropManager.getInstance());
        event.addListener((PreparableReloadListener)MobAdditionalDropManager.getInstance());
    }

    private void createNewRegistries(NewRegistryEvent event) {
        ForgeRegistration.bindCustomRegistries(event);
    }
}

