/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumLocatorResult;
import team.tnt.collectorsalbum.common.PlayerAlbumTracker;
import team.tnt.collectorsalbum.config.CollectorsAlbumConfig;
import team.tnt.collectorsalbum.integrations.PlatformIntegrations;
import team.tnt.collectorsalbum.network.NetworkManager;
import team.tnt.collectorsalbum.network.S2C_SendDatapackResources;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CollectorsAlbum {
    public static final String MOD_ID = "collectorsalbum";
    public static final Logger LOGGER = LogManager.getLogger((String)"CollectorsAlbum");
    public static final PlatformNetworkManager NETWORK_MANAGER = PlatformNetworkManager.create("collectorsalbum");
    private static CollectorsAlbumConfig config;

    public static void init() {
        config = (CollectorsAlbumConfig)Configuration.registerConfig(CollectorsAlbumConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        CollectorsAlbum.registerPackets();
        PlatformIntegrations.registerAlbumFinders();
    }

    public static CollectorsAlbumConfig getConfig() {
        return config;
    }

    public static void tickPlayer(Player player) {
        Level level = player.m_9236_();
        long time = level.m_46467_();
        if (level.m_5776_() || time % 100L != 0L) {
            return;
        }
        CollectorsAlbum.actuallyTickPlayer(player);
    }

    public static void forceAlbumReload(Player player) {
        if (!player.m_9236_().m_5776_()) {
            CollectorsAlbum.actuallyTickPlayer(player);
        }
    }

    private static void actuallyTickPlayer(Player player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        Album album = tracker.getAlbum(player).orElse(null);
        if (album == null) {
            AlbumLocatorResult result = tracker.findAlbum(player, null);
            if (!result.exists()) {
                tracker.deleteCachedAlbum(player.m_20148_(), player);
                return;
            }
            album = result.getAlbum();
            tracker.cacheAlbum(player, album);
        } else {
            AlbumLocatorResult result = tracker.findAlbum(player, album);
            if (!result.exists() || !result.getAlbum().test(album)) {
                tracker.deleteCachedAlbum(player.m_20148_(), player);
                if (result.getAlbum() != null) {
                    tracker.cacheAlbum(player, result.getAlbum());
                    result.getAlbum().tick(player);
                }
                return;
            }
        }
        album.tick(player);
    }

    public static void sendPlayerDatapacks(ServerPlayer player) {
        PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_SendDatapackResources());
        CollectorsAlbum.forceAlbumReload((Player)player);
    }

    public static void playerLoggedOut(Player player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.deleteCachedAlbum(player.m_20148_(), player);
    }

    public static void serverStopped() {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.clearCache();
    }

    private static void registerPackets() {
        NetworkManager.init();
    }
}

