/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.hash.Hashing;
import java.util.function.UnaryOperator;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import snownee.lychee.util.Couple;

public class Color {
    public static final Color TRANSPARENT_BLACK = new Color(0, 0, 0, 0).setImmutable();
    public static final Color BLACK = new Color(0, 0, 0).setImmutable();
    public static final Color WHITE = new Color(255, 255, 255).setImmutable();
    public static final Color RED = new Color(255, 0, 0).setImmutable();
    protected boolean mutable = true;
    protected int value;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public Color(float r, float g, float b, float a) {
        this((int)(0.5 + (double)(255.0f * Mth.m_14036_((float)r, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.m_14036_((float)g, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.m_14036_((float)b, (float)0.0f, (float)1.0f))), (int)(0.5 + (double)(255.0f * Mth.m_14036_((float)a, (float)0.0f, (float)1.0f))));
    }

    public Color(int rgba) {
        this.value = rgba;
    }

    public Color(int rgb, boolean hasAlpha) {
        this.value = hasAlpha ? rgb : rgb | 0xFF000000;
    }

    public Color copy() {
        return this.copy(true);
    }

    public Color copy(boolean mutable) {
        if (mutable) {
            return new Color(this.value);
        }
        return new Color(this.value).setImmutable();
    }

    public Color setImmutable() {
        this.mutable = false;
        return this;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public float getRedAsFloat() {
        return (float)this.getRed() / 255.0f;
    }

    public float getGreenAsFloat() {
        return (float)this.getGreen() / 255.0f;
    }

    public float getBlueAsFloat() {
        return (float)this.getBlue() / 255.0f;
    }

    public float getAlphaAsFloat() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRGB() {
        return this.value;
    }

    public Vec3 asVector() {
        return new Vec3((double)this.getRedAsFloat(), (double)this.getGreenAsFloat(), (double)this.getBlueAsFloat());
    }

    public Vector3f asVectorF() {
        return new Vector3f(this.getRedAsFloat(), this.getGreenAsFloat(), this.getBlueAsFloat());
    }

    public Color setRed(int r) {
        return this.ensureMutable().setRedUnchecked(r);
    }

    public Color setGreen(int g) {
        return this.ensureMutable().setGreenUnchecked(g);
    }

    public Color setBlue(int b) {
        return this.ensureMutable().setBlueUnchecked(b);
    }

    public Color setAlpha(int a) {
        return this.ensureMutable().setAlphaUnchecked(a);
    }

    public Color setRed(float r) {
        return this.ensureMutable().setRedUnchecked((int)(255.0f * Mth.m_14036_((float)r, (float)0.0f, (float)1.0f)));
    }

    public Color setGreen(float g) {
        return this.ensureMutable().setGreenUnchecked((int)(255.0f * Mth.m_14036_((float)g, (float)0.0f, (float)1.0f)));
    }

    public Color setBlue(float b) {
        return this.ensureMutable().setBlueUnchecked((int)(255.0f * Mth.m_14036_((float)b, (float)0.0f, (float)1.0f)));
    }

    public Color setAlpha(float a) {
        return this.ensureMutable().setAlphaUnchecked((int)(255.0f * Mth.m_14036_((float)a, (float)0.0f, (float)1.0f)));
    }

    public Color scaleAlpha(float factor) {
        return this.ensureMutable().setAlphaUnchecked((int)((float)this.getAlpha() * Mth.m_14036_((float)factor, (float)0.0f, (float)1.0f)));
    }

    public Color mixWith(Color other, float weight) {
        return this.ensureMutable().setRedUnchecked((int)((float)this.getRed() + (float)(other.getRed() - this.getRed()) * weight)).setGreenUnchecked((int)((float)this.getGreen() + (float)(other.getGreen() - this.getGreen()) * weight)).setBlueUnchecked((int)((float)this.getBlue() + (float)(other.getBlue() - this.getBlue()) * weight)).setAlphaUnchecked((int)((float)this.getAlpha() + (float)(other.getAlpha() - this.getAlpha()) * weight));
    }

    public Color darker() {
        int a = this.getAlpha();
        return this.ensureMutable().mixWith(BLACK, 0.25f).setAlphaUnchecked(a);
    }

    public Color brighter() {
        int a = this.getAlpha();
        return this.ensureMutable().mixWith(WHITE, 0.25f).setAlphaUnchecked(a);
    }

    public Color setValue(int value) {
        return this.ensureMutable().setValueUnchecked(value);
    }

    public Color modifyValue(UnaryOperator<Integer> function) {
        int newValue = (Integer)function.apply(this.value);
        if (newValue == this.value) {
            return this;
        }
        return this.ensureMutable().setValueUnchecked(newValue);
    }

    protected Color ensureMutable() {
        if (this.mutable) {
            return this;
        }
        return new Color(this.value);
    }

    protected Color setRedUnchecked(int r) {
        this.value = this.value & 0xFF00FFFF | (r & 0xFF) << 16;
        return this;
    }

    protected Color setGreenUnchecked(int g) {
        this.value = this.value & 0xFFFF00FF | (g & 0xFF) << 8;
        return this;
    }

    protected Color setBlueUnchecked(int b) {
        this.value = this.value & 0xFFFFFF00 | (b & 0xFF) << 0;
        return this;
    }

    protected Color setAlphaUnchecked(int a) {
        this.value = this.value & 0xFFFFFF | (a & 0xFF) << 24;
        return this;
    }

    protected Color setValueUnchecked(int value) {
        this.value = value;
        return this;
    }

    public static Color mixColors(@NotNull Color c1, @NotNull Color c2, float w) {
        return new Color((int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * w), (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * w), (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * w), (int)((float)c1.getAlpha() + (float)(c2.getAlpha() - c1.getAlpha()) * w));
    }

    public static Color mixColors(@NotNull Couple<Color> colors, float w) {
        return Color.mixColors((Color)colors.getFirst(), (Color)colors.getSecond(), w);
    }

    public static int mixColors(int color1, int color2, float w) {
        int a1 = color1 >> 24;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return ((int)((float)a1 + (float)(a2 - a1) * w) << 24) + ((int)((float)r1 + (float)(r2 - r1) * w) << 16) + ((int)((float)g1 + (float)(g2 - g1) * w) << 8) + ((int)((float)b1 + (float)(b2 - b1) * w) << 0);
    }

    public static Color rainbowColor(int timeStep) {
        int localTimeStep = Math.abs(timeStep) % 1536;
        int timeStepInPhase = localTimeStep % 256;
        int phaseBlue = localTimeStep / 256;
        int red = Color.colorInPhase(phaseBlue + 4, timeStepInPhase);
        int green = Color.colorInPhase(phaseBlue + 2, timeStepInPhase);
        int blue = Color.colorInPhase(phaseBlue, timeStepInPhase);
        return new Color(red, green, blue);
    }

    private static int colorInPhase(int phase, int progress) {
        if ((phase %= 6) <= 1) {
            return 0;
        }
        if (phase == 2) {
            return progress;
        }
        if (phase <= 4) {
            return 255;
        }
        return 255 - progress;
    }

    public static Color generateFromLong(long l) {
        return Color.rainbowColor(Hashing.crc32().hashLong(l).asInt()).mixWith(WHITE, 0.5f);
    }
}

