/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.interaction;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.recipe.ItemAndBlockRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;

public class BlockInteractingRecipe
extends ItemAndBlockRecipe<LycheeContext> {
    protected Ingredient otherInput = Ingredient.f_43901_;

    public BlockInteractingRecipe(ResourceLocation id) {
        super(id);
        this.maxRepeats = IntBoundsHelper.ONE;
    }

    @Override
    public boolean matches(LycheeContext ctx, Level pLevel) {
        if (!super.matches(ctx, pLevel)) {
            return false;
        }
        return this.otherInput.m_43947_() || this.otherInput.test(ctx.m_8020_(1));
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        if (this.otherInput.m_43947_()) {
            return super.m_7527_();
        }
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input, this.otherInput});
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.BLOCK_INTERACTING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.BLOCK_INTERACTING;
    }

    public static class Serializer<T extends BlockInteractingRecipe>
    extends ItemAndBlockRecipe.Serializer<T> {
        public Serializer(Function<ResourceLocation, T> factory) {
            super(factory);
        }

        @Override
        public void fromJson(T pRecipe, JsonObject pSerializedRecipe) {
            JsonElement element = pSerializedRecipe.get("item_in");
            if (element.isJsonObject()) {
                ((BlockInteractingRecipe)pRecipe).input = Serializer.parseIngredientOrAir(pSerializedRecipe.get("item_in"));
            } else {
                JsonArray array = element.getAsJsonArray();
                Preconditions.checkArgument((array.size() <= 2 ? 1 : 0) != 0, (Object)"Too many items in item_in");
                ((BlockInteractingRecipe)pRecipe).input = Serializer.parseIngredientOrAir(array.get(0));
                if (array.size() == 2) {
                    ((BlockInteractingRecipe)pRecipe).otherInput = Serializer.parseIngredientOrAir(array.get(1));
                }
            }
            ((BlockInteractingRecipe)pRecipe).block = BlockPredicateHelper.fromJson(pSerializedRecipe.get("block_in"));
        }

        @Override
        public void fromNetwork(T pRecipe, FriendlyByteBuf pBuffer) {
            super.fromNetwork(pRecipe, pBuffer);
            ((BlockInteractingRecipe)pRecipe).otherInput = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, T pRecipe) {
            super.toNetwork0(pBuffer, pRecipe);
            ((BlockInteractingRecipe)pRecipe).otherInput.m_43923_(pBuffer);
        }
    }
}

