/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class Explode
extends PostAction {
    public final Explosion.BlockInteraction blockInteraction;
    public final BlockPos offset;
    public final boolean fire;
    public final float radius;
    public final float step;

    public Explode(Explosion.BlockInteraction blockInteraction, BlockPos offset, boolean fire, float radius, float step) {
        this.blockInteraction = blockInteraction;
        this.offset = offset;
        this.fire = fire;
        this.radius = radius;
        this.step = step;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.EXPLODE;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Vec3 pos = (Vec3)ctx.getParam(LootContextParams.f_81460_);
        pos = pos.m_82520_((double)this.offset.m_123341_(), (double)this.offset.m_123342_(), (double)this.offset.m_123343_());
        float r = Math.min(this.radius + this.step * (Mth.m_14116_((float)times) - 1.0f), this.radius * 4.0f);
        CommonProxy.explode(this, ctx.getServerLevel(), pos, (Entity)ctx.getParamOrNull(LootContextParams.f_81455_), null, null, r);
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)(CommonProxy.makeDescriptionId("postAction", this.getType().getRegistryName()) + "." + this.blockInteraction.name().toLowerCase(Locale.ENGLISH)));
    }

    public static class Type
    extends PostActionType<Explode> {
        @Override
        public Explode fromJson(JsonObject o) {
            String s;
            BlockPos offset = CommonProxy.parseOffset(o);
            boolean fire = GsonHelper.m_13855_((JsonObject)o, (String)"fire", (boolean)false);
            Explosion.BlockInteraction blockInteraction = switch (s = GsonHelper.m_13851_((JsonObject)o, (String)"block_interaction", (String)"destroy")) {
                case "none", "keep" -> Explosion.BlockInteraction.KEEP;
                case "break", "destroy_with_decay" -> Explosion.BlockInteraction.DESTROY_WITH_DECAY;
                case "destroy" -> Explosion.BlockInteraction.DESTROY;
                default -> throw new IllegalArgumentException("Unexpected value: " + s);
            };
            float radius = GsonHelper.m_13820_((JsonObject)o, (String)"radius", (float)4.0f);
            float radiusStep = GsonHelper.m_13820_((JsonObject)o, (String)"radius_step", (float)0.5f);
            return new Explode(blockInteraction, offset, fire, radius, radiusStep);
        }

        @Override
        public void toJson(Explode action, JsonObject o) {
            BlockPos offset = action.offset;
            if (offset.m_123341_() != 0) {
                o.addProperty("offsetX", (Number)offset.m_123341_());
            }
            if (offset.m_123342_() != 0) {
                o.addProperty("offsetY", (Number)offset.m_123342_());
            }
            if (offset.m_123343_() != 0) {
                o.addProperty("offsetZ", (Number)offset.m_123341_());
            }
            if (action.fire) {
                o.addProperty("fire", Boolean.valueOf(true));
            }
            if (action.blockInteraction != Explosion.BlockInteraction.DESTROY) {
                o.addProperty("block_interaction", action.blockInteraction.name().toLowerCase(Locale.ENGLISH));
            }
            if (action.radius != 4.0f) {
                o.addProperty("radius", (Number)Float.valueOf(action.radius));
            }
            if (action.step != 0.5f) {
                o.addProperty("radius_step", (Number)Float.valueOf(action.step));
            }
        }

        @Override
        public Explode fromNetwork(FriendlyByteBuf buf) {
            Explosion.BlockInteraction blockInteraction = (Explosion.BlockInteraction)buf.m_130066_(Explosion.BlockInteraction.class);
            BlockPos offset = buf.m_130135_();
            boolean fire = buf.readBoolean();
            float radius = buf.readFloat();
            float step = buf.readFloat();
            return new Explode(blockInteraction, offset, fire, radius, step);
        }

        @Override
        public void toNetwork(Explode action, FriendlyByteBuf buf) {
            buf.m_130068_((Enum)action.blockInteraction);
            buf.m_130064_(action.offset);
            buf.writeBoolean(action.fire);
            buf.writeFloat(action.radius);
            buf.writeFloat(action.step);
        }
    }
}

