/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.ActionRuntime;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class Delay
extends PostAction {
    public final float seconds;

    public Delay(float seconds) {
        this.seconds = seconds;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DELAY;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        if (ctx.runtime.marker == null) {
            Delay.makeMarker(recipe, ctx);
        }
        ctx.runtime.marker.lychee$addDelay((int)(this.seconds * 20.0f));
        ctx.runtime.state = ActionRuntime.State.PAUSED;
    }

    public static void makeMarker(ILycheeRecipe<?> recipe, LycheeContext ctx) {
        Marker marker = (Marker)EntityType.f_147036_.m_20615_(ctx.getLevel());
        Vec3 pos = (Vec3)ctx.getParamOrNull(LootContextParams.f_81460_);
        if (pos != null) {
            marker.m_20219_(pos);
        }
        marker.m_6593_((Component)Component.m_237113_((String)"lychee"));
        ctx.getLevel().m_7967_((Entity)marker);
        LycheeMarker lycheeMarker = (LycheeMarker)marker;
        lycheeMarker.lychee$setContext(recipe, ctx);
        ctx.runtime.marker = lycheeMarker;
    }

    @Override
    public boolean preventSync() {
        return true;
    }

    public static interface LycheeMarker {
        public void lychee$setContext(ILycheeRecipe<?> var1, LycheeContext var2);

        public void lychee$addDelay(int var1);

        public LycheeContext lychee$getContext();

        default public Marker getEntity() {
            return (Marker)this;
        }
    }

    public static class Type
    extends PostActionType<Delay> {
        @Override
        public Delay fromJson(JsonObject o) {
            return new Delay(o.get("s").getAsFloat());
        }

        @Override
        public void toJson(Delay action, JsonObject o) {
            o.addProperty("s", (Number)Float.valueOf(action.seconds));
        }

        @Override
        public Delay fromNetwork(FriendlyByteBuf buf) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toNetwork(Delay action, FriendlyByteBuf buf) {
            throw new UnsupportedOperationException();
        }
    }
}

