/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.def;

import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import snownee.lychee.mixin.DoublesAccess;

public class DoubleBoundsHelper {
    public static MinMaxBounds.Doubles fromNetwork(FriendlyByteBuf pBuffer) {
        double min = pBuffer.readDouble();
        double max = pBuffer.readDouble();
        if (Double.isNaN(min) && Double.isNaN(max)) {
            return MinMaxBounds.Doubles.f_154779_;
        }
        return DoublesAccess.create(Double.isNaN(min) ? null : Double.valueOf(min), Double.isNaN(max) ? null : Double.valueOf(max));
    }

    public static void toNetwork(MinMaxBounds.Doubles doubles, FriendlyByteBuf pBuffer) {
        Double min = (Double)doubles.m_55305_();
        if (min == null) {
            min = Double.NaN;
        }
        pBuffer.writeDouble(min.doubleValue());
        Double max = (Double)doubles.m_55326_();
        if (max == null) {
            max = Double.NaN;
        }
        pBuffer.writeDouble(max.doubleValue());
    }

    public static float random(MinMaxBounds.Doubles doubles, RandomSource random) {
        float max;
        float min = doubles.m_55305_() == null ? Float.MIN_VALUE : ((Double)doubles.m_55305_()).floatValue();
        float f = max = doubles.m_55326_() == null ? Float.MAX_VALUE : ((Double)doubles.m_55326_()).floatValue();
        if (min == max) {
            return min;
        }
        return Mth.m_216283_((RandomSource)random, (float)min, (float)max);
    }
}

