/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public record IsWeather(String id, Predicate<Level> predicate) implements ContextualCondition
{
    public static final Map<String, IsWeather> REGISTRY = Maps.newConcurrentMap();
    public static IsWeather CLEAR = IsWeather.create("clear", level -> !level.m_46471_() && !level.m_46470_());
    public static IsWeather RAIN = IsWeather.create("rain", level -> level.m_46471_());
    public static IsWeather THUNDER = IsWeather.create("thunder", level -> level.m_46470_());

    public static IsWeather create(String id, Predicate<Level> predicate) {
        IsWeather isWeather = new IsWeather(id, predicate);
        REGISTRY.put(id, isWeather);
        return isWeather;
    }

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.WEATHER;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx.getLevel()) ? times : 0;
    }

    @Override
    public InteractionResult testInTooltips(Level level, @Nullable Player player) {
        return this.predicate.test(level) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        String key = this.makeDescriptionId(inverted);
        MutableComponent weather = Component.m_237115_((String)("weather.lychee." + this.id));
        return Component.m_237110_((String)key, (Object[])new Object[]{weather.m_130940_(ChatFormatting.WHITE)});
    }

    public static class Type
    extends ContextualConditionType<IsWeather> {
        @Override
        public IsWeather fromJson(JsonObject o) {
            return REGISTRY.get(o.get("weather").getAsString());
        }

        @Override
        public void toJson(IsWeather condition, JsonObject o) {
            o.addProperty("weather", condition.id());
        }

        @Override
        public IsWeather fromNetwork(FriendlyByteBuf buf) {
            return REGISTRY.get(buf.m_130277_());
        }

        @Override
        public void toNetwork(IsWeather condition, FriendlyByteBuf buf) {
            buf.m_130070_(condition.id());
        }
    }
}

