/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee;

import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import snownee.kiwi.Kiwi;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.util.CommonProxy;

public final class LycheeRegistries {
    public static MappedRegistry<ContextualConditionType<?>> CONTEXTUAL;
    public static MappedRegistry<PostActionType<?>> POST_ACTION;

    public static void init(NewRegistryEvent event) {
        LycheeRegistries.register("contextual", ContextualConditionType.class, event, v -> {
            CONTEXTUAL = v;
        });
        LycheeRegistries.register("post_action", PostActionType.class, event, v -> {
            POST_ACTION = v;
        });
    }

    private static <T> void register(String name, Class<?> clazz, NewRegistryEvent event, Consumer<MappedRegistry<T>> consumer) {
        RegistryBuilder builder = new RegistryBuilder().setName(new ResourceLocation("lychee", name));
        event.create(builder, v -> {
            consumer.accept(new MappedRegistry(v));
            if (CommonProxy.hasKiwi) {
                Kiwi.registerRegistry((IForgeRegistry)v, (Class)clazz);
            }
        });
    }

    public record MappedRegistry<T>(IForgeRegistry<T> registry) implements Iterable<T>
    {
        public ResourceKey<Registry<T>> key() {
            return this.registry.getRegistryKey();
        }

        public void register(ResourceLocation id, T t) {
            this.registry.register(id, t);
        }

        public T get(ResourceLocation key) {
            return (T)this.registry.getValue(key);
        }

        public ResourceLocation getKey(T t) {
            return this.registry.getKey(t);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }
}

