/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import me.superckl.api.superscript.util.WarningHelper;

public class CollectionHelper {
    public static <K, V> Map<K, V> linkedMapWithEntry(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <T> int find(T toFind, T[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != toFind && !in[i].equals(toFind)) continue;
            return i;
        }
        return -1;
    }

    public static int find(int toFind, int[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != toFind) continue;
            return i;
        }
        return -1;
    }

    public static int[] range(int start, int end) {
        int[] values = new int[end - start + 1];
        for (int i = start; i <= end; ++i) {
            values[i - start] = i;
        }
        return values;
    }

    public static void addAll(Collection<Integer> coll, int ... values) {
        for (int i : values) {
            coll.add(i);
        }
    }

    public static <T> boolean allContains(T element, Iterable<? extends Collection<T>> colls) {
        for (Collection<T> coll : colls) {
            if (coll.contains(element)) continue;
            return false;
        }
        return true;
    }

    public static String[] trimAll(String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static <T, V extends Collection<T>> V addAllFromArray(V addTo, Object array) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            addTo.add(WarningHelper.uncheckedCast(Array.get(array, i)));
        }
        return addTo;
    }

    public static <T, V> T reverseLookup(Map<T, V> map, V value) {
        for (Map.Entry<T, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }
}

