/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import openmods.api.IValueReceiver;
import openmods.gui.component.BaseComponent;
import openmods.gui.listener.IListenerBase;
import openmods.gui.misc.SidePicker;
import openmods.gui.misc.Trackball;
import openmods.utils.FakeBlockAccess;
import openmods.utils.MathUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.render.RenderUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiComponentSideSelector
extends BaseComponent
implements IValueReceiver<Set<EnumFacing>> {
    private static final double SQRT_3 = Math.sqrt(3.0);
    private final Trackball.TrackballWrapper trackball = new Trackball.TrackballWrapper(1, 40);
    private final int diameter;
    private final double scale;
    private EnumFacing lastSideHovered;
    private final Set<EnumFacing> selectedSides = EnumSet.noneOf(EnumFacing.class);
    private boolean highlightSelectedSides = true;
    private boolean isInInitialPosition;
    private ISideSelectedListener sideSelectedListener;
    private IBlockState blockState;
    private TileEntity te;
    private final FakeBlockAccess access;

    public GuiComponentSideSelector(int x, int y, double scale, IBlockState blockState, TileEntity te, boolean highlightSelectedSides) {
        super(x, y);
        this.scale = scale;
        this.diameter = MathHelper.func_76143_f((double)(scale * SQRT_3));
        this.blockState = blockState;
        this.te = te;
        this.access = new FakeBlockAccess(blockState, te);
        this.highlightSelectedSides = highlightSelectedSides;
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (!this.isInInitialPosition || Mouse.isButtonDown((int)2)) {
            Entity rve = this.parent.getMinecraft().func_175606_aa();
            this.trackball.setTransform(MathUtils.createEntityRotateMatrix(rve));
            this.isInInitialPosition = true;
        }
        int width = this.getWidth();
        int height = this.getWidth();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(offsetX + this.x + width / 2), (float)(offsetY + this.y + height / 2), (float)this.diameter);
        GL11.glScaled((double)this.scale, (double)(-this.scale), (double)this.scale);
        this.trackball.update(mouseX - width, -(mouseY - height));
        this.parent.bindTexture(TextureMap.field_110575_b);
        GlStateManager.func_179098_w();
        if (this.te != null) {
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(this.te, -0.5, -0.5, -0.5, 0.0f);
        }
        this.parent.bindTexture(TextureMap.field_110575_b);
        if (this.blockState != null) {
            this.drawBlock();
        }
        SidePicker picker = new SidePicker(0.5);
        ArrayList selections = Lists.newArrayListWithCapacity((int)7);
        SidePicker.HitCoord coord = picker.getNearestHit();
        if (coord != null) {
            selections.add(Pair.of((Object)((Object)coord.side), (Object)0x444444));
        }
        if (this.highlightSelectedSides) {
            for (EnumFacing dir : this.selectedSides) {
                selections.add(Pair.of((Object)((Object)SidePicker.Side.fromForgeDirection(dir)), (Object)0xCC0000));
            }
        }
        if (selections != null) {
            GuiComponentSideSelector.drawHighlight(selections);
        }
        this.lastSideHovered = coord == null ? null : coord.side.toForgeDirection();
        GL11.glPopMatrix();
    }

    private void drawBlock() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = this.parent.getMinecraft().func_175602_ab();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!this.blockState.func_177230_c().canRenderInLayer(this.blockState, layer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            wr.func_178969_c(-0.5, -0.5, -0.5);
            wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            dispatcher.func_175018_a(this.blockState, FakeBlockAccess.ORIGIN, (IBlockAccess)this.access, wr);
            tessellator.func_78381_a();
        }
        wr.func_178969_c(0.0, 0.0, 0.0);
        ForgeHooksClient.setRenderLayer(null);
    }

    private static void drawHighlight(List<Pair<SidePicker.Side, Integer>> selections) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GL11.glBegin((int)7);
        for (Pair<SidePicker.Side, Integer> p : selections) {
            Integer color = (Integer)p.getRight();
            RenderUtils.setColor(color, 0.5f);
            switch ((SidePicker.Side)((Object)p.getLeft())) {
                case XPos: {
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)0.5);
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)0.5);
                    break;
                }
                case YPos: {
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)-0.5);
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)-0.5);
                    break;
                }
                case ZPos: {
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)0.5);
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)0.5);
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)0.5);
                    break;
                }
                case XNeg: {
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)-0.5);
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)0.5);
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)0.5);
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)-0.5);
                    break;
                }
                case YNeg: {
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)0.5);
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)0.5);
                    break;
                }
                case ZNeg: {
                    GL11.glVertex3d((double)-0.5, (double)-0.5, (double)-0.5);
                    GL11.glVertex3d((double)-0.5, (double)0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)0.5, (double)-0.5);
                    GL11.glVertex3d((double)0.5, (double)-0.5, (double)-0.5);
                    break;
                }
            }
        }
        GL11.glEnd();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    private void toggleSide(EnumFacing side) {
        boolean wasntPresent;
        boolean bl = wasntPresent = !this.selectedSides.remove(side);
        if (wasntPresent) {
            this.selectedSides.add(side);
        }
        this.notifyListeners(side, wasntPresent);
    }

    private void notifyListeners(EnumFacing side, boolean wasntPresent) {
        if (this.sideSelectedListener != null) {
            this.sideSelectedListener.onSideToggled(side, wasntPresent);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
        if (button == 0 && this.lastSideHovered != null) {
            this.toggleSide(this.lastSideHovered);
        }
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
        this.lastSideHovered = null;
    }

    @Override
    public int getWidth() {
        return this.diameter;
    }

    @Override
    public int getHeight() {
        return this.diameter;
    }

    @Override
    public void setValue(Set<EnumFacing> dirs) {
        this.selectedSides.clear();
        this.selectedSides.addAll(dirs);
    }

    @Override
    public void setValue(IReadableBitMap<EnumFacing> dirs) {
        this.selectedSides.clear();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!dirs.get(dir)) continue;
            this.selectedSides.add(dir);
        }
    }

    public void setListener(ISideSelectedListener sideSelectedListener) {
        this.sideSelectedListener = sideSelectedListener;
    }

    @FunctionalInterface
    public static interface ISideSelectedListener
    extends IListenerBase {
        public void onSideToggled(EnumFacing var1, boolean var2);
    }
}

