/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import info.openmods.calc.utils.StackUnderflowException;
import info.openmods.calc.utils.StackValidationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Stack<E>
implements Iterable<E> {
    private final List<E> data;
    private final int bottomElement;

    public Stack() {
        this.data = Lists.newArrayList();
        this.bottomElement = 0;
    }

    public Stack(int initialCapacity) {
        this.data = Lists.newArrayListWithCapacity((int)initialCapacity);
        this.bottomElement = 0;
    }

    private Stack(List<E> data, int bottomElement) {
        this.data = data;
        this.bottomElement = bottomElement;
    }

    public void push(E value) {
        this.data.add(value);
    }

    public void pushAll(Collection<E> values) {
        this.data.addAll(values);
    }

    public void checkIsNonEmpty() {
        if (this.isEmpty()) {
            throw new StackUnderflowException();
        }
    }

    private void checkIndex(int index) {
        if (index < this.bottomElement) {
            throw new StackUnderflowException();
        }
    }

    public E pop() {
        this.checkIsNonEmpty();
        try {
            return this.data.remove(this.data.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new StackUnderflowException();
        }
    }

    public E popAndExpectEmptyStack() {
        if (this.size() != 1) {
            throw new StackUnderflowException("Expected exactly one element, got %d, contents: %s", this.size(), this.printContents());
        }
        return this.pop();
    }

    private int indexFromTop(int index) {
        return this.data.size() - 1 - index;
    }

    public E peek(int index) {
        int peekIndex = this.indexFromTop(index);
        this.checkIndex(peekIndex);
        return this.data.get(peekIndex);
    }

    public void dup() {
        this.checkIsNonEmpty();
        E last = this.data.get(this.data.size() - 1);
        this.data.add(last);
    }

    public E drop(int index) {
        int dropIndex = this.indexFromTop(index);
        this.checkIndex(dropIndex);
        return this.data.remove(dropIndex);
    }

    public int size() {
        return this.data.size() - this.bottomElement;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static <T> Stack<T> create() {
        return new Stack();
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.listIterator(this.bottomElement);
    }

    public void clear() {
        int size;
        if (this.bottomElement == 0) {
            this.data.clear();
        }
        if ((size = this.data.size()) - this.bottomElement > 0) {
            this.data.subList(this.bottomElement, size).clear();
        }
    }

    public Stack<E> substack(int depth) {
        int newBottom = this.data.size() - depth;
        if (newBottom < this.bottomElement) {
            throw new StackUnderflowException(String.format("Not enough elements to create substack: required %s, size %d", depth, this.size()));
        }
        return newBottom == 0 ? this : new Stack<E>(this.data, newBottom);
    }

    public Stack<E> checkIsEmpty() {
        if (!this.isEmpty()) {
            throw new StackValidationException("Expected empty stack, but actually contains: %s", this.printContents());
        }
        return this;
    }

    public Stack<E> checkSizeIsExactly(int expectedSize) {
        if (this.size() != expectedSize) {
            throw new StackUnderflowException("Expected stack size %d, got %d, contents: %s", expectedSize, this.size(), this.printContents());
        }
        return this;
    }

    public Stack<E> checkSizeIsAtLeast(int expectedSize) {
        if (this.size() < expectedSize) {
            throw new StackUnderflowException("Expected stack size >= %d, got %d, contents: %s", expectedSize, this.size(), this.printContents());
        }
        return this;
    }

    public String printContents() {
        return Iterables.toString((Iterable)this);
    }

    public String toString() {
        return this.printContents();
    }
}

