/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.SymbolGet;
import info.openmods.calc.executable.UnaryOperator;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.types.multi.ArgUnpackCompilerHelper;
import info.openmods.calc.types.multi.TypedValue;
import java.util.List;

public class VarArgSymbolCallNode
extends SymbolCallNode<TypedValue> {
    private final UnaryOperator<TypedValue> unpackMarker;

    public VarArgSymbolCallNode(UnaryOperator<TypedValue> unpackMarker, String symbol, List<? extends IExprNode<TypedValue>> args) {
        super(symbol, args);
        this.unpackMarker = unpackMarker;
    }

    @Override
    public void flatten(final List<IExecutable<TypedValue>> output) {
        new ArgUnpackCompilerHelper(this.unpackMarker){

            @Override
            protected void compileWithVarArgs(int normalArgCount, List<IExecutable<TypedValue>> compiledArgs) {
                output.add(new SymbolGet(VarArgSymbolCallNode.this.symbol));
                output.addAll(compiledArgs);
                output.add(new SymbolCall("applyvar", normalArgCount + 2, 1));
            }

            @Override
            protected void compileWithoutVarArgs(int allArgs, List<IExecutable<TypedValue>> compiledArgs) {
                output.addAll(compiledArgs);
                output.add(new SymbolCall(VarArgSymbolCallNode.this.symbol, allArgs, 1));
            }
        }.compileArgUnpack(this.getChildren());
    }
}

