/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.SingleReturnCallable;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypeUserdata;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class StructSymbol
extends SingleReturnCallable<TypedValue> {
    private static final String ATTR_FIELDS = "fields";
    private final TypedValue nullValue;
    private final TypeDomain domain;
    private static AtomicInteger structCounter = new AtomicInteger(0);

    public StructSymbol(TypedValue nullValue) {
        this.nullValue = nullValue;
        this.domain = nullValue.domain;
        this.domain.registerType(StructType.class, "struct_type", this.createStructTypeMetaObject());
        this.domain.registerType(StructValue.class, "struct", this.createStructValueMetaObject());
    }

    private static void extractValues(Iterable<TypedValue> args, Set<String> fields, Map<String, TypedValue> output) {
        for (TypedValue arg : args) {
            if (arg.is(Cons.class)) {
                Cons pair = arg.as(Cons.class);
                Preconditions.checkState((boolean)pair.car.is(Symbol.class), (String)"Expected key(symbol):value pair, got %s", (Object)arg);
                String key = pair.car.as(Symbol.class).value;
                Preconditions.checkArgument((boolean)fields.contains(key), (String)"Unknown key: %s", (Object)key);
                output.put(key, pair.cdr);
                continue;
            }
            throw new IllegalArgumentException("Expected key:value pair, got " + arg);
        }
    }

    private MetaObject createStructValueMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                return Optional.fromNullable(self.as(StructValue.class).values.get(key));
            }
        }).set(new MetaObject.SlotDir(){

            @Override
            public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                return self.as(StructValue.class).values.keySet();
            }
        }).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                StructValue value = self.as(StructValue.class);
                ArrayList entries = Lists.newArrayList();
                for (String field : value.type.fieldNames) {
                    entries.add(field + "=" + MetaObjectUtils.callStrSlot(frame, (TypedValue)value.values.get(field)));
                }
                return "{" + Joiner.on((String)",").join((Iterable)entries) + "}";
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                StructValue value = self.as(StructValue.class);
                ArrayList entries = Lists.newArrayList();
                for (String field : value.type.fieldNames) {
                    entries.add("#" + field + ":" + MetaObjectUtils.callReprSlot(frame, (TypedValue)value.values.get(field)));
                }
                return "struct(" + Joiner.on((String)",").join((Iterable)entries) + ")";
            }
        }).set(new MetaObject.SlotType(){

            @Override
            public TypedValue type(TypedValue self, Frame<TypedValue> frame) {
                return self.as(StructValue.class).type.selfValue;
            }
        }).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                StructValue value = self.as(StructValue.class);
                TypedCalcUtils.expectSingleReturn(returnsCount);
                Stack<TypedValue> stack = frame.stack().substack(argumentsCount.or(value.type.fieldNames.size()));
                HashMap newValues = Maps.newHashMap((Map)value.values);
                StructSymbol.extractValues(stack, value.type.fieldNames, newValues);
                stack.clear();
                stack.push(StructSymbol.this.domain.create(StructValue.class, new StructValue(value.type, newValues)));
            }
        }).build();
    }

    private MetaObject createStructTypeMetaObject() {
        return MetaObject.builder().set(TypeUserdata.defaultAttrSlot(this.domain)).set(TypeUserdata.defaultDirSlot()).set(MetaObjectUtils.DECOMPOSE_ON_TYPE).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                TypedCalcUtils.expectSingleReturn(returnsCount);
                StructType type = self.as(StructType.class);
                int argCount = argumentsCount.or(type.fieldNames.size());
                Stack<TypedValue> stack = frame.stack().substack(argCount);
                HashMap values = Maps.newHashMap();
                for (String field : type.fieldNames) {
                    values.put(field, StructSymbol.this.nullValue);
                }
                StructSymbol.extractValues(stack, type.fieldNames, values);
                TypedValue result = StructSymbol.this.domain.create(StructValue.class, new StructValue(type, values));
                stack.clear();
                stack.push(result);
            }
        }).build();
    }

    @Override
    public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
        Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'struct' symbol requires arguments count");
        Stack<TypedValue> args = frame.stack().substack(argumentsCount.get());
        ArrayList fields = Lists.newArrayList();
        for (TypedValue arg : args) {
            if (arg.is(Symbol.class)) {
                Symbol symbol = arg.as(Symbol.class);
                fields.add(symbol.value);
                continue;
            }
            throw new IllegalArgumentException("Expected symbol, got " + arg);
        }
        TypedValue result = this.domain.create(StructType.class, new StructType(fields));
        args.clear();
        return result;
    }

    private class StructType
    extends TypeUserdata {
        private final Set<String> fieldNames;
        private final TypedValue fieldsList;
        private final TypedValue selfValue;

        public StructType(List<String> fields) {
            super("struct_" + structCounter.incrementAndGet(), StructValue.class);
            this.fieldNames = Sets.newLinkedHashSet();
            this.fieldNames.addAll(fields);
            ArrayList wrappedFieldNames = Lists.newArrayList((Iterable)Iterables.transform(this.fieldNames, StructSymbol.this.domain.createWrappingTransformer(String.class)));
            this.fieldsList = Cons.createList(wrappedFieldNames, StructSymbol.this.nullValue);
            this.selfValue = StructSymbol.this.domain.create(StructType.class, this);
        }

        @Override
        protected Optional<TypedValue> attr(TypeDomain domain, String key) {
            if (key.equals(StructSymbol.ATTR_FIELDS)) {
                return Optional.of((Object)this.fieldsList);
            }
            if (key.equals("name")) {
                return Optional.of((Object)domain.create(String.class, "struct"));
            }
            return super.attr(domain, key);
        }

        @Override
        protected Iterable<String> dir() {
            ArrayList result = Lists.newArrayList(super.dir());
            result.add(StructSymbol.ATTR_FIELDS);
            return result;
        }
    }

    private class StructValue {
        private final StructType type;
        private final Map<String, TypedValue> values;

        public StructValue(StructType type, Map<String, TypedValue> values) {
            this.type = type;
            this.values = ImmutableMap.copyOf(values);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StructValue) {
                StructValue other = (StructValue)obj;
                return this.type == other.type && this.values.equals(other.values);
            }
            return false;
        }
    }
}

