/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.upgrade;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.api.IThEUpgrade;
import thaumicenergistics.api.IThEUpgrades;
import thaumicenergistics.upgrade.ThEUpgrade;

public class ThEUpgrades
implements IThEUpgrades {
    private IThEUpgrade arcaneCharger;
    private IThEUpgrade knowledgeCore;
    private IThEUpgrade blankKnowledgeCore;
    private IThEUpgrade cardSpeed;
    private List<IThEUpgrade> upgrades = new ArrayList<IThEUpgrade>();

    public ThEUpgrades(IThEItems items) {
        this.arcaneCharger = new ThEUpgrade(items.upgradeArcane());
        this.upgrades.add(this.arcaneCharger);
        this.knowledgeCore = new ThEUpgrade(items.knowledgeCore());
        this.upgrades.add(this.knowledgeCore);
        this.blankKnowledgeCore = new ThEUpgrade(items.blankKnowledgeCore());
        this.upgrades.add(this.blankKnowledgeCore);
        this.cardSpeed = new ThEUpgrade(AEApi.instance().definitions().materials().cardSpeed());
        this.upgrades.add(this.cardSpeed);
    }

    @Override
    public IThEUpgrade arcaneCharger() {
        return this.arcaneCharger;
    }

    @Override
    public IThEUpgrade knowledgeCore() {
        return this.knowledgeCore;
    }

    @Override
    public IThEUpgrade blankKnowledgeCore() {
        return this.blankKnowledgeCore;
    }

    @Override
    public IThEUpgrade cardSpeed() {
        return this.cardSpeed;
    }

    @Override
    public Optional<IThEUpgrade> getUpgrade(ItemStack stack) {
        return this.getUpgrades().stream().filter(upgrade -> upgrade.getDefinition().isSameAs(stack)).findFirst();
    }

    @Override
    public List<IThEUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void registerUpgrade(IItemDefinition upgradable, IThEUpgrade upgrade, int max) {
        upgradable.maybeStack(1).ifPresent(stack -> upgrade.registerItem((ItemStack)stack, max));
    }
}

