/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumcraft.api.aura.AuraHelper;
import thaumicenergistics.api.IThELangKey;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.client.gui.IThEGuiTile;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketAssemblerGUIUpdate;
import thaumicenergistics.tile.TileNetwork;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.IThESubscribable;
import thaumicenergistics.util.KnowledgeCoreUtil;
import thaumicenergistics.util.TCUtil;
import thaumicenergistics.util.ThELog;
import thaumicenergistics.util.inventory.IThEInvTile;
import thaumicenergistics.util.inventory.ThEInternalInventory;
import thaumicenergistics.util.inventory.ThEKnowledgeCoreInventory;
import thaumicenergistics.util.inventory.ThEUpgradeInventory;

public class TileArcaneAssembler
extends TileNetwork
implements IThESubscribable,
IThEInvTile,
IThEGuiTile,
ICraftingProvider,
IStorageMonitorable,
IGridTickable {
    protected static final int BASE_STEP = 5;
    private IItemStorageChannel channel;
    protected ThEInternalInventory coreInv;
    protected ThEUpgradeInventory upgradeInv;
    protected ThEInternalInventory craftingInv;
    protected int progress = 0;
    protected HashMap<String, Boolean> aspectExists = new HashMap();
    protected boolean hasEnoughVis = true;
    protected AtomicBoolean missingAspect = new AtomicBoolean(false);
    protected boolean hasJob = false;
    protected boolean isCrafting = false;
    protected boolean noPushFlag = false;

    public TileArcaneAssembler() {
        ItemStack assemblerItem = (ItemStack)ThEApi.instance().blocks().arcaneAssembler().maybeStack(1).orElseThrow(RuntimeException::new);
        this.coreInv = new ThEKnowledgeCoreInventory("cores", 1, 1, assemblerItem);
        this.upgradeInv = new ThEUpgradeInventory("upgrades", 5, 1, assemblerItem);
        this.craftingInv = new ThEInternalInventory("crafting", 1, 64);
        this.channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = super.func_189517_E_();
        nbtTagCompound.func_74757_a("missingAspect", this.missingAspect.get());
        nbtTagCompound.func_74757_a("hasEnoughVis", this.hasEnoughVis);
        nbtTagCompound.func_74757_a("hasJob", this.hasJob);
        nbtTagCompound.func_74757_a("isCrafting", this.isCrafting);
        nbtTagCompound.func_74768_a("progress", this.getProgress());
        return this.func_189515_b(nbtTagCompound);
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.missingAspect.set(tag.func_74767_n("missingAspect"));
        this.hasEnoughVis = tag.func_74767_n("hasEnoughVis");
        this.hasJob = tag.func_74767_n("hasJob");
        this.isCrafting = tag.func_74767_n("isCrafting");
        this.progress = tag.func_74762_e("progress");
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("cores", (NBTBase)this.coreInv.serializeNBT());
        tag.func_74782_a("upgrades", (NBTBase)this.upgradeInv.serializeNBT());
        tag.func_74782_a("crafting", (NBTBase)this.craftingInv.serializeNBT());
        super.func_189515_b(tag);
        return tag;
    }

    @ParametersAreNonnullByDefault
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("cores")) {
            this.coreInv.deserializeNBT(tag.func_150295_c("cores", 10));
        }
        if (tag.func_74764_b("upgrades")) {
            this.upgradeInv.deserializeNBT(tag.func_150295_c("upgrades", 10));
        }
        if (tag.func_74764_b("crafting")) {
            this.craftingInv.deserializeNBT(tag.func_150295_c("crafting", 10));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public void openGUI(EntityPlayer player) {
        GuiHandler.openGUI(this.getGUI(), player, this.func_174877_v());
    }

    @Override
    public ModGUIs getGUI() {
        return ModGUIs.ARCANE_ASSEMBLER;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        switch (name) {
            case "cores": {
                return new InvWrapper((IInventory)this.coreInv);
            }
            case "upgrades": {
                return new InvWrapper((IInventory)this.upgradeInv);
            }
        }
        return null;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (!this.isActive()) {
            return;
        }
        ItemStack knowledgeCore = this.coreInv.func_70301_a(0);
        KnowledgeCoreUtil.recipeStreamOf(knowledgeCore).map(recipe -> KnowledgeCoreUtil.getAEPattern(recipe, this.field_145850_b)).forEach(AEPattern -> {
            AEPattern.setPriority(0);
            craftingTracker.addCraftingOption((ICraftingMedium)this, AEPattern);
        });
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        boolean canCraft;
        ItemStack result = patternDetails.getOutputs()[0].createItemStack();
        KnowledgeCoreUtil.Recipe recipe = KnowledgeCoreUtil.getRecipe(this.coreInv.func_70301_a(0), result);
        if (recipe == null) {
            return false;
        }
        this.noPushFlag = false;
        this.hasJob = true;
        this.isCrafting = false;
        boolean prevHasEnoughVis = this.hasEnoughVis;
        boolean prevMissingAspect = this.missingAspect.get();
        HashMap<String, Boolean> prevAspectExists = this.aspectExists;
        this.hasEnoughVis = this.getWorldVis() >= recipe.getVisCost();
        this.aspectExists = new HashMap();
        IMEMonitor inventory = this.getInventory((IStorageChannel)this.channel);
        ArrayList<ItemStack> aspects = new ArrayList<ItemStack>();
        this.missingAspect.set(false);
        recipe.getIngredientPart(true).forEach(aspect -> {
            if (!aspect.func_190926_b()) {
                IAEItemStack canExtractAmount = (IAEItemStack)AEUtil.inventoryExtract(this.channel.createStack(aspect), inventory, (IActionSource)this.src, Actionable.SIMULATE);
                String aspectName = Objects.requireNonNull(TCUtil.getCrystalAspect(aspect)).getTag();
                this.aspectExists.put(aspectName, canExtractAmount != null && canExtractAmount.getStackSize() == (long)aspect.func_190916_E());
                if (this.aspectExists.get(aspectName).booleanValue()) {
                    aspects.add((ItemStack)aspect);
                } else {
                    this.missingAspect.set(true);
                }
            }
        });
        boolean bl = canCraft = this.hasEnoughVis && !this.missingAspect.get();
        if (canCraft) {
            this.aspectExists = new HashMap();
        }
        if (prevHasEnoughVis != this.hasEnoughVis || prevMissingAspect != this.missingAspect.get()) {
            this.func_70296_d();
        }
        if (prevHasEnoughVis != this.hasEnoughVis || !prevAspectExists.equals(this.aspectExists)) {
            this.notifySubs();
        }
        if (!canCraft) {
            return false;
        }
        aspects.forEach(aspect -> {
            IAEItemStack cfr_ignored_0 = (IAEItemStack)AEUtil.inventoryExtract(this.channel.createStack(aspect), inventory, this.src);
        });
        if (recipe.getVisCost() > 0.0f) {
            ItemStack visRangeUpgrade = (ItemStack)ThEApi.instance().items().upgradeArcane().maybeStack(1).orElseThrow(RuntimeException::new);
            TCUtil.drainVis(this.func_145831_w(), this.func_174877_v(), recipe.getVisCost(), this.upgradeInv.getUpgrades(visRangeUpgrade));
        }
        this.progress = 0;
        this.craftingInv.func_70299_a(0, result);
        return true;
    }

    public boolean isBusy() {
        return !this.craftingInv.func_70301_a(0).func_190926_b();
    }

    @MENetworkEventSubscribe
    public void onChannelChange(MENetworkChannelsChanged event) {
        this.init();
    }

    @MENetworkEventSubscribe
    public void onBootChange(MENetworkPowerStatusChange event) {
        if (this.isActive()) {
            this.init();
        }
    }

    public void init() {
        this.func_70296_d();
        if (ForgeUtil.isServer()) {
            this.getActionableNode().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getActionableNode()));
            this.channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            ((ITickManager)this.gridNode.getGrid().getCache(ITickManager.class)).wakeDevice(this.gridNode);
        }
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        try {
            return GridUtil.getStorageGrid(this).getInventory(channel);
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(ThEApi.instance().config().tickTimeArcaneAssemblerMin(), ThEApi.instance().config().tickTimeArcaneAssemblerMax(), !this.isBusy(), false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.craftingInv.func_70301_a(0).func_190926_b()) {
            this.isCrafting = false;
            if (this.hasJob) {
                if (this.noPushFlag) {
                    this.hasJob = false;
                    this.missingAspect.set(false);
                    this.aspectExists = new HashMap();
                    this.hasEnoughVis = true;
                    this.func_70296_d();
                    this.notifySubs();
                } else {
                    this.noPushFlag = true;
                }
            }
            return TickRateModulation.SLOWER;
        }
        this.isCrafting = true;
        this.progress += this.getStep();
        if (this.progress >= 100) {
            IAEItemStack stack = (IAEItemStack)this.channel.createStack((Object)this.craftingInv.func_70301_a(0));
            IMEMonitor inventory = this.getInventory((IStorageChannel)this.channel);
            if (Stream.of(stack, inventory, this.src).anyMatch(Objects::isNull)) {
                this.progress -= this.getStep();
                ThELog.trace("Arcane Assembler @ (" + this.func_174877_v().func_177958_n() + ", " + this.func_174877_v().func_177956_o() + ", " + this.func_174877_v().func_177952_p() + "): ME system not ready for crafting yet, retrying...", new Object[0]);
                return TickRateModulation.SAME;
            }
            AEUtil.inventoryInsert(this.channel.createStack((Object)this.craftingInv.func_70301_a(0)), this.getInventory((IStorageChannel)this.channel), this.src);
            this.craftingInv.func_70304_b(0);
            if (this.craftingInv.func_70301_a(0).func_190926_b()) {
                this.hasJob = false;
            }
        }
        this.func_70296_d();
        return TickRateModulation.URGENT;
    }

    protected void notifySubs() {
        this.notifySubs(player -> PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketAssemblerGUIUpdate(this)));
    }

    public HashMap<String, Boolean> getAspectExists() {
        return this.aspectExists;
    }

    public boolean getHasEnoughVis() {
        return this.hasEnoughVis;
    }

    public boolean isMissingAspect() {
        return this.missingAspect.get();
    }

    public int getProgress() {
        return MathHelper.func_76125_a((int)this.progress, (int)0, (int)100);
    }

    public boolean hasJob() {
        return this.hasJob;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public void withInfoText(Consumer<String> consumer, Function<IThELangKey, String> localizationMapper) {
        if (this.isActive()) {
            if (this.hasJob()) {
                if (this.isCrafting()) {
                    consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerBusy()));
                    consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerProgress()) + " " + this.getProgress() + "%");
                } else {
                    consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerPrep()));
                    if (this.isMissingAspect()) {
                        consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerNoAspect()));
                    }
                    if (!this.getHasEnoughVis()) {
                        consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerNoVis()));
                    }
                }
            } else {
                consumer.accept(localizationMapper.apply(ThEApi.instance().lang().arcaneAssemblerIdle()));
            }
        }
    }

    protected int getStep() {
        AtomicInteger step = new AtomicInteger(5);
        AEApi.instance().definitions().materials().cardSpeed().maybeStack(1).ifPresent(cardSpeed -> step.set((int)(5.0 + Math.pow(3.0, this.upgradeInv.getUpgrades(cardSpeed)))));
        return step.get();
    }

    protected float getWorldVis() {
        return ThEApi.instance().items().upgradeArcane().maybeStack(1).map(visRangeUpgrade -> {
            float vis = AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
            if (this.upgradeInv.getUpgrades(visRangeUpgrade) > 0) {
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(-16, 0, -16));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(-16, 0, 0));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(-16, 0, 16));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(0, 0, -16));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(0, 0, 16));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(16, 0, -16));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(16, 0, 0));
                vis += AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(16, 0, 16));
            }
            return Float.valueOf(vis);
        }).orElse(Float.valueOf(AuraHelper.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v()))).floatValue();
    }

    public ThEInternalInventory getCraftingInv() {
        return this.craftingInv;
    }

    @Override
    public void getDrops(World world, BlockPos blockPos, List<ItemStack> list) {
        super.getDrops(world, blockPos, list);
        this.coreInv.iterator().forEachRemaining(list::add);
        this.upgradeInv.iterator().forEachRemaining(list::add);
    }
}

