/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.me.GridAccessException;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.container.crafting.ContainerCraftAmountBridge;
import thaumicenergistics.container.crafting.ContainerCraftConfirmBridge;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.integration.appeng.grid.IThEGridHost;
import thaumicenergistics.part.PartBase;

public class PacketCraftRequest
implements IMessage {
    private int amount;
    private boolean shift;

    public PacketCraftRequest() {
    }

    public PacketCraftRequest(int amount, boolean shift) {
        this.amount = amount;
        this.shift = shift;
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
        this.shift = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
        buf.writeBoolean(this.shift);
    }

    public static class Handler
    implements IMessageHandler<PacketCraftRequest, IMessage> {
        public IMessage onMessage(PacketCraftRequest message, MessageContext ctx) {
            NetHandlerPlayServer handler = ctx.getServerHandler();
            EntityPlayerMP player = handler.field_147369_b;
            IThreadListener thread = (IThreadListener)player.field_70170_p;
            thread.func_152344_a(() -> {
                block5: {
                    if (!(player.field_71070_bA instanceof ContainerCraftAmountBridge)) {
                        return;
                    }
                    ContainerCraftAmountBridge ca = (ContainerCraftAmountBridge)player.field_71070_bA;
                    if (!(ca.getTarget() instanceof PartBase) || !(ca.getTarget() instanceof IThEGridHost) || ca.getItemToCraft() == null) {
                        return;
                    }
                    PartBase part = (PartBase)ca.getTarget();
                    IGridNode node = part.getGridNode();
                    ca.getItemToCraft().setStackSize((long)message.amount);
                    Future job = null;
                    try {
                        ICraftingGrid cg = GridUtil.getCraftingGrid(node);
                        job = cg.beginCraftingJob(ca.getWorld(), ca.getGrid(), ca.getActionSrc(), ca.getItemToCraft(), null);
                        GuiHandler.openGUI(ModGUIs.AE2_CRAFT_CONFIRM, (EntityPlayer)player, part.getLocation().getPos(), part.side);
                        if (player.field_71070_bA instanceof ContainerCraftConfirmBridge) {
                            ContainerCraftConfirmBridge cc = (ContainerCraftConfirmBridge)player.field_71070_bA;
                            cc.setAutoStart(message.shift);
                            cc.setJob(job);
                            cc.func_75142_b();
                        }
                    }
                    catch (GridAccessException ignored) {
                        if (job == null) break block5;
                        job.cancel(true);
                    }
                }
            });
            return null;
        }
    }
}

