/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.item;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import thaumicenergistics.api.IThEUpgrade;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.render.IThEModel;
import thaumicenergistics.item.ItemBase;

public class ItemMaterial
extends ItemBase
implements IThEModel {
    public ItemMaterial(String id) {
        super(id);
    }

    public ItemMaterial(String id, int stackSize) {
        this(id);
        this.func_77625_d(stackSize);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Optional<IThEUpgrade> optional = ThEApi.instance().upgrades().getUpgrade(stack);
        optional.ifPresent(upgrade -> {
            String supported = upgrade.getSupported().keySet().stream().map(ItemStack::func_82833_r).collect(Collectors.joining(", "));
            if (!supported.isEmpty()) {
                tooltip.add("Used in: " + supported);
            }
        });
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void initModel() {
        Preconditions.checkNotNull((Object)this.getRegistryName());
        Preconditions.checkNotNull((Object)this.getRegistryName().func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("thaumicenergistics:material/" + this.getRegistryName().func_110623_a(), "inventory"));
    }
}

