/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.EssentiaStack;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.item.ItemDummyAspect;

public class AEEssentiaStack
implements IAEEssentiaStack,
Comparable<AEEssentiaStack> {
    private Aspect aspect;
    private long stackSize;
    private long countRequestable;
    private boolean isCraftable;
    private int hash;

    private AEEssentiaStack(Aspect aspect, long amount) {
        this.aspect = aspect;
        if (this.aspect == null) {
            throw new IllegalArgumentException("Aspect is null");
        }
        this.setStackSize(amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.hash = this.aspect.hashCode();
    }

    private AEEssentiaStack(AEEssentiaStack stack) {
        this.aspect = stack.getAspect();
        if (this.aspect == null) {
            throw new IllegalArgumentException("Aspect is null");
        }
        this.setStackSize(stack.getStackSize());
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.hash = stack.hash;
    }

    public static AEEssentiaStack fromEssentiaStack(EssentiaStack stack) {
        if (stack == null) {
            return null;
        }
        return new AEEssentiaStack(stack.getAspect(), stack.getAmount());
    }

    public static IAEEssentiaStack fromNBT(NBTTagCompound t) {
        EssentiaStack stack = EssentiaStack.readFromNBT(t);
        if (stack == null) {
            return null;
        }
        AEEssentiaStack ae = AEEssentiaStack.fromEssentiaStack(stack);
        ae.setStackSize(t.func_74763_f("AspectAmount"));
        ae.setCountRequestable(t.func_74763_f("Req"));
        ae.setCraftable(t.func_74767_n("Craft"));
        return new AEEssentiaStack(stack.getAspect(), stack.getAmount());
    }

    public static IAEEssentiaStack fromPacket(ByteBuf buf) {
        return AEEssentiaStack.fromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public IAEEssentiaStack setStackSize(long l) {
        this.stackSize = l;
        return this;
    }

    public long getCountRequestable() {
        return this.countRequestable;
    }

    public IAEEssentiaStack setCountRequestable(long l) {
        this.countRequestable = l;
        return this;
    }

    public boolean isCraftable() {
        return this.isCraftable;
    }

    public IAEEssentiaStack setCraftable(boolean b) {
        this.isCraftable = b;
        return this;
    }

    public IAEEssentiaStack reset() {
        this.setStackSize(0L);
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return this;
    }

    public boolean isMeaningful() {
        return this.getAspect() != null && this.getStackSize() != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    public void incStackSize(long l) {
        this.setStackSize(Math.min(Integer.MAX_VALUE, this.getStackSize() + l));
    }

    public void decStackSize(long l) {
        this.setStackSize(this.getStackSize() - l);
    }

    public void incCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() + l);
    }

    public void decCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() - l);
    }

    @Override
    public Aspect getAspect() {
        return this.aspect;
    }

    @Override
    public EssentiaStack getStack() {
        return new EssentiaStack(this.getAspect(), (int)Math.min(Integer.MAX_VALUE, this.stackSize));
    }

    public void add(IAEEssentiaStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    public void writeToNBT(NBTTagCompound t) {
        t.func_74778_a("Aspect", this.getAspect().getTag());
        t.func_74774_a("Count", (byte)0);
        t.func_74772_a("Amount", this.getStackSize());
        t.func_74772_a("Req", this.getCountRequestable());
        t.func_74757_a("Craft", this.isCraftable());
    }

    public void writeToPacket(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IAEEssentiaStack copy() {
        return new AEEssentiaStack(this);
    }

    public IAEEssentiaStack empty() {
        IAEEssentiaStack copy = this.copy();
        copy.reset();
        return copy;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<IAEEssentiaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        ItemStack stack = ThEApi.instance().items().dummyAspect().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            ((ItemDummyAspect)stack.func_77973_b()).setAspect(stack, this.aspect);
        }
        return stack;
    }

    public boolean fuzzyComparison(IAEEssentiaStack other, FuzzyMode mode) {
        return this.aspect == other.getAspect();
    }

    @Override
    public int compareTo(AEEssentiaStack o) {
        int diff = this.hashCode() - o.hashCode();
        return Integer.compare(diff, 0);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AEEssentiaStack) {
            return ((AEEssentiaStack)obj).getAspect().getTag().equalsIgnoreCase(this.getAspect().getTag());
        }
        if (obj instanceof EssentiaStack) {
            return ((EssentiaStack)obj).getAspect().getTag().equalsIgnoreCase(this.getAspect().getTag());
        }
        return false;
    }
}

