/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.block;

import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.items.materials.ItemMaterial;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.container.slot.SlotKnowledgeCore;
import thaumicenergistics.container.slot.SlotUpgrade;
import thaumicenergistics.item.ItemKnowledgeCore;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketPlaySound;
import thaumicenergistics.tile.TileArcaneAssembler;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;

public class ContainerArcaneAssembler
extends ContainerBase {
    protected TileArcaneAssembler TE;

    public ContainerArcaneAssembler(EntityPlayer player, TileArcaneAssembler TE) {
        super(player);
        this.TE = TE;
        this.func_75146_a(new SlotKnowledgeCore(this.getInventory("cores"), 0, 81, 66));
        for (int i = 0; i < this.getInventory("upgrades").getSlots(); ++i) {
            this.func_75146_a(new SlotUpgrade(this.getInventory("upgrades"), i, 186, 8 + i * 18));
        }
        this.bindPlayerInventory((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), 0, 147);
        this.func_75132_a(new KnowledgeCoreSlotListener());
        if (ForgeUtil.isServer()) {
            TE.subscribe(player);
        }
    }

    public IItemHandler getInventory(String name) {
        return this.TE.getInventoryByName(name);
    }

    public TileArcaneAssembler getTE() {
        return this.TE;
    }

    public void playCoreSound(EntityPlayer player) {
        if (this.getInventory("cores").getStackInSlot(0).func_190926_b()) {
            player.field_70170_p.func_184133_a(player, this.TE.func_174877_v(), new SoundEvent(ThEApi.instance().sounds().knowledgeCorePowerDown()), SoundCategory.BLOCKS, 1.0f, 1.0f);
            PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketPlaySound(this.TE.func_174877_v(), ThEApi.instance().sounds().knowledgeCorePowerDown(), SoundCategory.BLOCKS, 1.0f, 1.0f));
        } else {
            player.field_70170_p.func_184133_a(player, this.TE.func_174877_v(), new SoundEvent(ThEApi.instance().sounds().knowledgeCorePowerUp()), SoundCategory.BLOCKS, 1.0f, 1.0f);
            PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketPlaySound(this.TE.func_174877_v(), ThEApi.instance().sounds().knowledgeCorePowerUp(), SoundCategory.BLOCKS, 1.0f, 1.0f));
        }
    }

    @Override
    protected void handleQuickMove(Slot slot, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemKnowledgeCore) {
            ItemHandlerUtil.quickMoveSlot(this.getInventory("cores"), slot);
        } else if (item instanceof thaumicenergistics.item.ItemMaterial || item instanceof ItemMaterial) {
            ItemHandlerUtil.quickMoveSlot(this.getInventory("upgrades"), slot);
        }
    }

    private class KnowledgeCoreSlotListener
    implements IContainerListener {
        private boolean opened = false;

        private KnowledgeCoreSlotListener() {
        }

        @ParametersAreNonnullByDefault
        public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
            if (slotInd == 0 && this.opened && ForgeUtil.isServer()) {
                IGridNode node = ContainerArcaneAssembler.this.TE.getActionableNode();
                ContainerArcaneAssembler.this.playCoreSound(ContainerArcaneAssembler.this.player);
                node.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)ContainerArcaneAssembler.this.TE, node));
            }
            this.opened = true;
        }

        @ParametersAreNonnullByDefault
        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        @ParametersAreNonnullByDefault
        public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        }

        @ParametersAreNonnullByDefault
        public void func_175173_a(Container containerIn, IInventory inventory) {
        }
    }
}

