/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.helpers;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import invtweaks.api.InvTweaksAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.config.PrefixSetting;
import thaumicenergistics.client.gui.helpers.GuiScrollBar;
import thaumicenergistics.integration.invtweaks.ThEInvTweaks;
import thaumicenergistics.integration.jei.ThEJEI;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.TCUtil;

public class MERepo<T extends IAEStack<T>> {
    private IItemList<T> list;
    private ArrayList<T> view = new ArrayList();
    private String searchString = "";
    private ViewItems viewMode;
    private SortDir sortDir;
    private SortOrder sortOrder;
    private SearchBoxMode searchBoxMode;
    private GuiScrollBar scrollBar;
    private int rowSize = 9;

    public MERepo(Class<? extends IStorageChannel<T>> clazz) {
        this.list = AEUtil.getList(clazz);
        this.viewMode = ViewItems.ALL;
        this.sortDir = SortDir.ASCENDING;
        this.sortOrder = SortOrder.NAME;
        this.searchBoxMode = ThEApi.instance().config().searchBoxMode();
    }

    public void updateView() {
        Pattern pattern;
        this.view.clear();
        this.view.ensureCapacity(this.list.size());
        String search = this.searchString;
        boolean sbm = false;
        boolean sba = false;
        boolean searchSpecific = false;
        PrefixSetting modSearchSetting = ThEApi.instance().config().modSearchSetting();
        PrefixSetting aspectSearchSetting = ThEApi.instance().config().aspectSearchSetting();
        if (Stream.of(SearchBoxMode.JEI_AUTOSEARCH, SearchBoxMode.JEI_MANUAL_SEARCH, SearchBoxMode.JEI_AUTOSEARCH_KEEP, SearchBoxMode.JEI_MANUAL_SEARCH_KEEP).anyMatch(m -> m == this.searchBoxMode)) {
            ThEJEI.setSearchText(search);
        }
        switch (modSearchSetting) {
            case ENABLED: {
                sbm = true;
            }
            case REQUIRE_PREFIX: {
                if (!search.startsWith(ThEApi.instance().config().modSearchPrefix())) break;
                search = search.substring(ThEApi.instance().config().modSearchPrefix().length());
                searchSpecific = true;
                sbm = true;
            }
        }
        if (!searchSpecific) {
            switch (aspectSearchSetting) {
                case ENABLED: {
                    sba = true;
                }
                case REQUIRE_PREFIX: {
                    if (!search.startsWith(ThEApi.instance().config().aspectSearchPrefix())) break;
                    search = search.substring(ThEApi.instance().config().aspectSearchPrefix().length());
                    searchSpecific = true;
                    sba = true;
                    sbm = false;
                }
            }
        }
        try {
            pattern = Pattern.compile(search, 66);
        }
        catch (PatternSyntaxException ignored) {
            try {
                pattern = Pattern.compile(Pattern.quote(search), 66);
            }
            catch (PatternSyntaxException ignored2) {
                return;
            }
        }
        Pattern p = pattern;
        boolean searchByMod = sbm;
        boolean searchByAspect = sba;
        Stream<Object> stream = StreamSupport.stream(this.list.spliterator(), false);
        stream = stream.filter(t -> this.getViewMode() != ViewItems.CRAFTABLE || t.isCraftable() || this.getViewMode() != ViewItems.STORED || t.getStackSize() != 0L);
        if (searchSpecific) {
            if (searchByAspect) {
                stream = stream.filter(t -> this.searchAspects(t, p));
            } else if (searchByMod) {
                stream = stream.filter(t -> this.searchMod(t, p));
            }
        } else {
            stream = stream.filter(t -> {
                if (searchByAspect && this.searchAspects(t, p)) {
                    return true;
                }
                if (searchByMod && this.searchMod(t, p)) {
                    return true;
                }
                return this.searchName(t, p) || this.searchTooltip(t, p);
            });
        }
        stream.forEach(t -> {
            IAEStack stack = t.copy();
            if (this.getViewMode().equals((Object)ViewItems.CRAFTABLE)) {
                if (!stack.isCraftable()) {
                    return;
                }
                stack.setStackSize(0L);
            } else if (this.getViewMode().equals((Object)ViewItems.STORED) && stack.getStackSize() < 1L) {
                return;
            }
            this.view.add(stack);
        });
        if (this.sortOrder == SortOrder.MOD) {
            this.sortByMod();
        } else if (this.sortOrder == SortOrder.NAME) {
            this.sortByName();
        } else if (this.sortOrder == SortOrder.AMOUNT) {
            this.sortByCount();
        } else if (this.sortOrder == SortOrder.INVTWEAKS) {
            this.sortByInvTweaks();
        }
        if (this.getScrollBar() != null) {
            if (this.view.size() <= this.getRowSize() * 6) {
                this.getScrollBar().setRows(6);
                this.getScrollBar().click(this.scrollBar.getY());
            } else {
                this.getScrollBar().setRows((int)Math.ceil(this.view.size() * this.getRowSize()));
            }
        }
    }

    public void postUpdate(T stack) {
        IAEStack existing = this.list.findPrecise(stack);
        if (existing != null) {
            existing.reset();
            existing.add(stack);
        } else {
            this.list.add(stack);
        }
    }

    public T getReferenceStack(int i) {
        int scroll = (int)Math.max(Math.min((double)this.scrollBar.getCurrentPosition(), Math.ceil((double)this.view.size() / (double)this.rowSize)), 0.0);
        if ((i += scroll * this.rowSize) < this.view.size()) {
            return (T)((IAEStack)this.view.get(i));
        }
        return null;
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public void setScrollBar(GuiScrollBar scrollBar) {
        this.scrollBar = scrollBar;
    }

    public GuiScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setViewMode(ViewItems view) {
        this.viewMode = view;
    }

    public ViewItems getViewMode() {
        return this.viewMode;
    }

    public SortDir getSortDir() {
        return this.sortDir;
    }

    public void setSortDir(SortDir sortDir) {
        this.sortDir = sortDir;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SearchBoxMode getSearchBoxMode() {
        return this.searchBoxMode;
    }

    public void setSearchBoxMode(SearchBoxMode searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    private boolean searchName(T stack, Pattern p) {
        return p.matcher(Platform.getItemDisplayName(stack)).find();
    }

    private boolean searchTooltip(T stack, Pattern p) {
        List tooltip = Platform.getTooltip(stack);
        for (String line : tooltip) {
            if (!p.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private boolean searchMod(T stack, Pattern p) {
        if (stack instanceof IAEItemStack) {
            return p.matcher(Platform.getModId((IAEItemStack)((IAEItemStack)stack))).find();
        }
        if (stack instanceof IAEFluidStack) {
            return p.matcher(Platform.getModId((IAEFluidStack)((IAEFluidStack)stack))).find();
        }
        return true;
    }

    private boolean searchAspects(T stack, Pattern p) {
        AspectList aspects = TCUtil.getItemAspects(stack.asItemStackRepresentation());
        if (aspects == null || aspects.size() < 1) {
            return false;
        }
        Pattern pf = p;
        Stream stream = aspects.aspects.keySet().stream();
        return stream.anyMatch(aspect -> pf.matcher(aspect.getName()).find());
    }

    private int checkSortDir(int i) {
        return this.getSortDir() == SortDir.ASCENDING ? i : -i;
    }

    private void sortByName() {
        this.view.sort((o1, o2) -> this.checkSortDir(AEUtil.getDisplayName(o1).compareToIgnoreCase(AEUtil.getDisplayName(o2))));
    }

    private void sortByMod() {
        this.view.sort((o1, o2) -> {
            int i = AEUtil.getModID(o1).compareToIgnoreCase(AEUtil.getModID(o2));
            if (i == 0) {
                i = AEUtil.getDisplayName(o1).compareToIgnoreCase(AEUtil.getDisplayName(o2));
            }
            return this.checkSortDir(i);
        });
    }

    private void sortByCount() {
        this.view.sort((o1, o2) -> this.checkSortDir(Long.compare(AEUtil.getStackSize(o2), AEUtil.getStackSize(o1))));
    }

    private void sortByInvTweaks() {
        InvTweaksAPI api = ThEInvTweaks.getApi();
        if (api == null) {
            this.sortByName();
        } else {
            this.view.sort((o1, o2) -> this.checkSortDir(api.compareItems(o1.asItemStackRepresentation(), o2.asItemStackRepresentation())));
        }
    }
}

