/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.component;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiImageButton
extends GuiButtonImage {
    private static final AtomicInteger ID = new AtomicInteger(1000);
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    private static final int YDIFFTEXT = 0;
    private int offsetX;
    private int offsetY;
    private ResourceLocation image;
    private ResourceLocation hoverImage;
    private ResourceLocation buttonTexture;
    private String text;
    private String hoverText;
    private int hoverOffsetX;
    private int hoverOffsetY;
    private float buttonAlpha = 1.0f;
    private float buttonHoverAlpha = 1.0f;
    private float imageAlpha = 1.0f;
    private float imageHoverAlpha = 1.0f;
    private float textAlpha = 1.0f;
    private float textHoverAlpha = 1.0f;

    public GuiImageButton(int x, int y, String resource) {
        this(x, y, 0, 0, resource);
    }

    public GuiImageButton(int x, int y, int indexX, int indexY, String resource) {
        this(x, y, 16, 16, indexX * 16, indexY * 16, resource);
    }

    public GuiImageButton(int x, int y, int w, int h, int offsetX, int offsetY, String resource) {
        this(x, y, w, h, offsetX, offsetY, new ResourceLocation("thaumicenergistics", resource));
    }

    public GuiImageButton(int x, int y, ResourceLocation resource) {
        this(x, y, 0, 0, resource);
    }

    public GuiImageButton(int x, int y, int indexX, int indexY, ResourceLocation resource) {
        this(x, y, 16, 16, indexX * 16, indexY * 16, resource);
    }

    public GuiImageButton(int x, int y, int w, int h, int offsetX, int offsetY, ResourceLocation resource) {
        super(ID.getAndIncrement(), x, y, w, h, offsetX, offsetY, 0, resource);
        this.image = this.hoverImage = resource;
        this.offsetX = this.hoverOffsetX = offsetX;
        this.offsetY = this.hoverOffsetY = offsetY;
    }

    public GuiImageButton recalculateY(int slots) {
        this.field_146129_i += slots * 18;
        return this;
    }

    @ParametersAreNonnullByDefault
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_146123_n ? this.buttonHoverAlpha : this.buttonAlpha));
            mc.func_110434_K().func_110577_a(field_146122_a);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g / 2);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g / 2);
            this.func_73729_b(this.field_146128_h, this.field_146129_i + this.field_146121_g / 2, 0, 58 + i * 20, this.field_146120_f / 2, this.field_146121_g / 2);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g / 2, 200 - this.field_146120_f / 2, 58 + i * 20, this.field_146120_f / 2, this.field_146121_g / 2);
            if (this.field_146123_n) {
                this.field_73735_i = -10.0f;
                if (this.hoverImage != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.imageHoverAlpha);
                    mc.func_110434_K().func_110577_a(this.hoverImage);
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, this.hoverOffsetX, this.hoverOffsetY, this.field_146120_f, this.field_146121_g);
                }
                if (this.hoverText != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.textHoverAlpha);
                    int j = 0xFFFFA0;
                    if (this.packedFGColour != 0) {
                        j = this.packedFGColour;
                    } else if (!this.field_146124_l) {
                        j = 0xA0A0A0;
                    }
                    this.func_73732_a(mc.field_71466_p, this.hoverText, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
                }
            } else {
                if (this.image != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.imageAlpha);
                    mc.func_110434_K().func_110577_a(this.image);
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, this.offsetX, this.offsetY, this.field_146120_f, this.field_146121_g);
                }
                if (this.text != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.textAlpha);
                    int j = 0xE0E0E0;
                    if (this.packedFGColour != 0) {
                        j = this.packedFGColour;
                    } else if (!this.field_146124_l) {
                        j = 0xA0A0A0;
                    }
                    this.func_73732_a(mc.field_71466_p, this.text, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void setTextAlpha(float textAlpha, float textHoverAlpha) {
        this.textAlpha = textAlpha;
        this.textHoverAlpha = textHoverAlpha;
    }

    public void setImageAlpha(float imageAlpha, float imageHoverAlpha) {
        this.imageAlpha = imageAlpha;
        this.imageHoverAlpha = imageHoverAlpha;
    }

    public void setButtonAlpha(float buttonAlpha, float buttonHoverAlpha) {
        this.buttonAlpha = buttonAlpha;
        this.buttonHoverAlpha = buttonHoverAlpha;
    }

    public GuiImageButton setButtonTexture(ResourceLocation buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public GuiImageButton setButtonTexture(String buttonTexture) {
        return this.setButtonTexture(new ResourceLocation("thaumicenergistics", buttonTexture));
    }

    public GuiImageButton setAllImages(ResourceLocation resource, int offsetX, int offsetY) {
        this.setImage(resource, offsetX, offsetY);
        this.setHoverImage(resource, offsetX, offsetY);
        return this;
    }

    public GuiImageButton setImage(ResourceLocation resource, int offsetX, int offsetY) {
        this.image = resource;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        return this;
    }

    public GuiImageButton setImage(String resource, int offsetX, int offsetY) {
        return this.setImage(new ResourceLocation("thaumicenergistics", resource), offsetX, offsetY);
    }

    public GuiImageButton setImage(String resource) {
        return this.setImage(resource, 0, 0);
    }

    public GuiImageButton setImage(ResourceLocation resource) {
        return this.setImage(resource, 0, 0);
    }

    public GuiImageButton setHoverImage(ResourceLocation resource, int offsetX, int offsetY) {
        this.hoverImage = resource;
        this.hoverOffsetX = offsetX;
        this.hoverOffsetY = offsetY;
        return this;
    }

    public GuiImageButton setHoverImage(String resource, int offsetX, int offsetY) {
        return this.setHoverImage(new ResourceLocation("thaumicenergistics", resource), offsetX, offsetY);
    }

    public GuiImageButton setHoverImage(String resource) {
        return this.setHoverImage(resource, 0, 0);
    }

    public GuiImageButton setHoverImage(ResourceLocation resource) {
        return this.setHoverImage(resource, 0, 0);
    }

    public GuiImageButton setAllText(String text) {
        this.setText(text);
        this.setHoverText(text);
        return this;
    }

    public GuiImageButton setText(String text) {
        this.text = this.field_146126_j = text;
        if (this.hoverText == null) {
            this.hoverText = text;
        }
        return this;
    }

    public GuiImageButton setHoverText(String text) {
        this.hoverText = text;
        return this;
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public ResourceLocation getHoverImage() {
        return this.hoverImage;
    }

    public String getText() {
        return this.text;
    }

    public String getHoverText() {
        return this.hoverText;
    }

    public ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    public boolean isHovered() {
        return this.field_146123_n;
    }
}

