/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.block;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.gui.GuiBase;
import thaumicenergistics.container.block.ContainerArcaneAssembler;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketAssemblerGUIUpdateRequest;
import thaumicenergistics.network.packets.PacketSubscribe;
import thaumicenergistics.tile.TileArcaneAssembler;

public class GuiArcaneAssembler
extends GuiBase {
    private static final String[] aspects = new String[]{"aer", "terra", "ignis", "aqua", "ordo", "perditio"};
    private static final int[][] aspectGUILoc = new int[][]{{69, 2}, {21, 82}, {21, 25}, {117, 25}, {117, 82}, {69, 106}};
    private static final ResourceLocation BACKGROUND_INACTIVE = new ResourceLocation("thaumicenergistics", "textures/gui/arcane_assembler/inactive.png");
    private static final ResourceLocation BACKGROUND_ACTIVE = new ResourceLocation("thaumicenergistics", "textures/gui/arcane_assembler/active.png");
    private static final ResourceLocation ASPECTS = new ResourceLocation("thaumicenergistics", "textures/gui/arcane_assembler/aspects.png");
    private static final int WIDTH = 210;
    private static final int HEIGHT = 231;
    private final ContainerArcaneAssembler container;
    private final IItemHandler inv;
    private float enAlpha;
    private boolean hasEnoughVis = true;
    private HashMap<String, Boolean> aspectExists = new HashMap();

    public GuiArcaneAssembler(ContainerArcaneAssembler container) {
        super(container);
        this.container = container;
        this.inv = container.getInventory("cores");
        this.enAlpha = this.inv.getStackInSlot(0).func_190926_b() ? 0.0f : 1.0f;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getGuiBackground() {
        return BACKGROUND_INACTIVE;
    }

    public void func_73866_w_() {
        PacketHandler.sendToServer(new PacketAssemblerGUIUpdateRequest(this.container.getTE()));
        this.field_146999_f = 210;
        this.field_147000_g = 231;
        super.func_73866_w_();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(ThEApi.instance().lang().tileArcaneAssembler().getLocalizedKey(new Object[0]), 8, 3, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.getYSize() - 92, 0x404040);
        if (!this.inv.getStackInSlot(0).func_190926_b()) {
            if (this.aspectExists.containsValue(false)) {
                this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiOutOfAspect().getLocalizedKey(new Object[0]), 100, this.getYSize() - 92, Color.RED.getRGB());
            }
            if (!this.hasEnoughVis) {
                this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiOutOfVis().getLocalizedKey(new Object[0]), 115, 3, Color.RED.getRGB());
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.inv.getStackInSlot(0).func_190926_b()) {
            if (this.enAlpha > 0.0f) {
                this.enAlpha -= 0.05f * partialTicks;
            }
        } else if (this.enAlpha < 1.0f) {
            this.enAlpha += 0.05f * partialTicks;
        }
        if (this.enAlpha < 1.0f) {
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_INACTIVE);
            GuiArcaneAssembler.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
        }
        if (this.enAlpha > 0.0f) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.enAlpha);
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_ACTIVE);
            GuiArcaneAssembler.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(ASPECTS);
        for (int i = 0; i < 6; ++i) {
            Boolean haveAspect = this.aspectExists.get(aspects[i]);
            int x = aspectGUILoc[i][0];
            int y = aspectGUILoc[i][1];
            if (haveAspect != null && !this.inv.getStackInSlot(0).func_190926_b()) {
                if (!haveAspect.booleanValue()) {
                    float alpha = (float)((MathHelper.sin((double)((double)Minecraft.func_71386_F() / 200.0 % (Math.PI * 2))) + 1.0) / 2.0);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * this.enAlpha));
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + this.enAlpha * 0.8f));
                }
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + this.enAlpha * 0.5f));
            }
            GuiArcaneAssembler.func_146110_a((int)(this.field_147003_i + x), (int)(this.field_147009_r + y), (float)x, (float)y, (int)40, (int)40, (float)this.field_146999_f, (float)this.field_147000_g);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.sendToServer(new PacketSubscribe<TileArcaneAssembler>(this.container.getTE(), false));
    }

    public void updateGUI(HashMap<String, Boolean> aspectExists, boolean hasEnoughVis) {
        this.aspectExists = aspectExists;
        this.hasEnoughVis = hasEnoughVis;
    }
}

