/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumicenergistics.init.ModGlobals;
import thaumicenergistics.tile.TileBase;
import thaumicenergistics.util.ForgeUtil;

public abstract class BlockBase
extends Block {
    private static final Random rand = new Random();

    public BlockBase(String id) {
        this(id, Material.field_151573_f);
    }

    public BlockBase(String id, Material material) {
        super(material);
        this.setRegistryName(id);
        this.func_149663_c("thaumicenergistics." + id);
        this.func_149647_a(ModGlobals.CREATIVE_TAB);
        this.func_149711_c(1.0f);
    }

    public void registerTileEntity() {
    }

    private static double randCoordOffset(int coord) {
        return (double)(rand.nextInt() % 32 - 16) / 82.0 + 0.5 + (double)coord;
    }

    public static void spawnDrops(World world, BlockPos pos, List<ItemStack> drops) {
        if (ForgeUtil.isClient()) {
            return;
        }
        drops.parallelStream().filter(is -> !is.func_190926_b()).forEach(is -> world.func_72838_d((Entity)new EntityItem(world, BlockBase.randCoordOffset(pos.func_177958_n()), BlockBase.randCoordOffset(pos.func_177956_o()), BlockBase.randCoordOffset(pos.func_177952_p()), is)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileBase)) {
            return;
        }
        TileBase tb = (TileBase)te;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        tb.getDrops(worldIn, pos, drops);
        BlockBase.spawnDrops(worldIn, pos, drops);
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

