/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.recipe.custom.RecipeMatch;
import org.cyclops.cyclopscore.recipe.custom.RecipePropertyMatcher;
import org.cyclops.cyclopscore.recipe.custom.RecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeMatch;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeMatcher;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;

public class SuperRecipeRegistry
implements ISuperRecipeRegistry {
    private final Map<IMachine, List<IRecipe>> recipes = Maps.newHashMap();
    private final Map<IMachine, RecipeRegistry> registries = Maps.newHashMap();
    private final ModBase mod;

    public SuperRecipeRegistry(ModBase mod) {
        this.mod = mod;
    }

    public <M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> RecipeRegistry<M, I, O, P> getRecipeRegistry(M machine) {
        RecipeRegistry registry = this.registries.get(machine);
        if (registry == null) {
            registry = new RecipeRegistry(machine, this.mod);
            this.registries.put(machine, registry);
        }
        return registry;
    }

    @Override
    public List<IRecipe> getRecipes(IMachine machine) {
        List<IRecipe> list = this.recipes.get(machine);
        if (list == null) {
            list = new ArrayList<IRecipe>();
            this.recipes.put(machine, list);
        }
        return list;
    }

    @Override
    public IRecipeMatch<IMachine, IRecipe> findRecipeByNamedId(String namedId) {
        return new RecipePropertyMatcher<IMachine, IRecipe, String>(namedId){

            @Override
            public String getProperty(IMachine machine, IRecipe recipe) {
                return recipe.getNamedId();
            }
        }.findRecipe(this);
    }

    @Override
    public List<IRecipeMatch<IMachine, IRecipe>> findRecipesByInput(IRecipeInput input) {
        return new RecipePropertyMatcher<IMachine, IRecipe, IRecipeInput>(input){

            @Override
            public IRecipeInput getProperty(IMachine machine, IRecipe recipe) {
                return recipe.getInput();
            }
        }.findRecipes(this);
    }

    @Override
    public List<IRecipeMatch<IMachine, IRecipe>> findRecipesByMachine(IMachine machine) {
        ArrayList<IRecipeMatch<IMachine, IRecipe>> list = new ArrayList<IRecipeMatch<IMachine, IRecipe>>();
        for (IRecipe recipe : this.getRecipes(machine)) {
            list.add(new RecipeMatch<IMachine, IRecipe>(machine, recipe));
        }
        return list;
    }

    public <M extends IMachine, R extends IRecipe> RecipeMatch<M, R> findRecipe(IRecipeMatcher<M, R> recipeMatcher) {
        for (Map.Entry<IMachine, List<IRecipe>> entry : this.recipes.entrySet()) {
            IMachine machine = entry.getKey();
            List<IRecipe> recipes = entry.getValue();
            for (IRecipe recipe : recipes) {
                if (!recipeMatcher.matches(machine, recipe)) continue;
                return new RecipeMatch<IMachine, IRecipe>(machine, recipe);
            }
        }
        return null;
    }

    @Override
    public <M extends IMachine, R extends IRecipe> List<IRecipeMatch<M, R>> findRecipes(IRecipeMatcher<M, R> recipeMatcher) {
        ArrayList<IRecipeMatch<M, R>> results = new ArrayList<IRecipeMatch<M, R>>();
        for (Map.Entry<IMachine, List<IRecipe>> entry : this.recipes.entrySet()) {
            IMachine machine = entry.getKey();
            List<IRecipe> recipes = entry.getValue();
            for (IRecipe recipe : recipes) {
                if (!recipeMatcher.matches(machine, recipe)) continue;
                results.add(new RecipeMatch<IMachine, IRecipe>(machine, recipe));
            }
        }
        return results;
    }
}

