/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ValueNotifyPacket
extends PacketCodec {
    @CodecField
    private String guiModId;
    @CodecField
    private int guiId;
    @CodecField
    private int valueId;
    @CodecField
    private NBTTagCompound value;

    public ValueNotifyPacket() {
    }

    public ValueNotifyPacket(String guiModId, int guiId, int valueId, NBTTagCompound value) {
        this.guiModId = guiModId;
        this.guiId = guiId;
        this.valueId = valueId;
        this.value = value;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    protected boolean isContainerValid(IValueNotifiable container) {
        return container.getGuiId() == this.guiId && container.getGuiModId().equals(this.guiModId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        IValueNotifiable container;
        if (player.field_71070_bA instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.field_71070_bA)) {
            container.onUpdate(this.valueId, this.value);
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        IValueNotifiable container;
        if (player.field_71070_bA instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.field_71070_bA)) {
            container.onUpdate(this.valueId, this.value);
        }
    }
}

