/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;

public abstract class DamageIndicatedItemFluidContainer
extends ItemFluidContainer
implements IInformationProvider {
    protected DamageIndicatedItemComponent component;
    protected Fluid fluid;

    public DamageIndicatedItemFluidContainer(int capacity, Fluid fluid) {
        super(capacity);
        this.fluid = fluid;
        this.init();
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        if (!ItemStackHelpers.isValidCreativeTab((Item)this, tab)) {
            return;
        }
        this.component.getSubItems(tab, itemList, this.fluid, 0);
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        this.component.addInformation(itemStack, world, list, flag);
        super.func_77624_a(itemStack, world, list, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, 1.0f - (float)this.component.getDurability(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack simulatedDrain = fluidHandler.drain(amount, false);
        return simulatedDrain != null && simulatedDrain.amount == amount;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemCapacity(stack, this.capacity, this.getFluid());
    }
}

