/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;

public class FilteredIngredientMapIterator<T, M, V>
implements Iterator<Map.Entry<T, V>> {
    private final Iterator<Map.Entry<T, V>> iterator;
    private final IIngredientMatcher<T, M> matcher;
    private final T instance;
    private final M matchCondition;
    private Map.Entry<T, V> next;

    public FilteredIngredientMapIterator(Iterator<Map.Entry<T, V>> iterator, IIngredientMatcher<T, M> matcher, T instance, M matchCondition) {
        this.iterator = iterator;
        this.matcher = matcher;
        this.instance = instance;
        this.matchCondition = matchCondition;
        this.next = null;
    }

    protected Map.Entry<T, V> findNext() {
        while (this.iterator.hasNext()) {
            Map.Entry<T, V> next = this.iterator.next();
            if (!this.matcher.matches(this.instance, next.getKey(), this.matchCondition)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.findNext();
        }
        return this.next != null;
    }

    @Override
    public Map.Entry<T, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Tried reading a finished FilteredIngredientMapIterator");
        }
        Map.Entry<T, V> next = this.next;
        this.next = null;
        return next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

