/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final int dimensionId;
    private final BlockPos blockPos;
    private WeakReference<World> worldReference;

    private DimPos(int dimensionId, BlockPos blockPos, World world) {
        this.dimensionId = dimensionId;
        this.blockPos = blockPos;
        this.worldReference = world != null && world.field_72995_K ? new WeakReference<World>(world) : null;
    }

    private DimPos(int dimensionId, BlockPos blockPos) {
        this(dimensionId, blockPos, null);
    }

    @Nullable
    public World getWorld() {
        if (this.worldReference == null) {
            return DimensionManager.getWorld((int)this.dimensionId);
        }
        World world = (World)this.worldReference.get();
        if (world == null) {
            world = DimensionManager.getWorld((int)this.dimensionId);
            this.worldReference = new WeakReference<World>(world);
        }
        return world;
    }

    public boolean isLoaded() {
        World world = this.getWorld();
        return world != null && world.func_175667_e(this.getBlockPos());
    }

    @Override
    public int compareTo(DimPos o) {
        int compareDim = Integer.compare(this.getDimensionId(), o.getDimensionId());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    public boolean equals(Object o) {
        return o instanceof DimPos && this.compareTo((DimPos)o) == 0;
    }

    public int hashCode() {
        return 31 * this.getDimensionId() + this.getBlockPos().hashCode();
    }

    public static DimPos of(World world, BlockPos blockPos) {
        return new DimPos(world.field_73011_w.getDimension(), blockPos, world);
    }

    public static DimPos of(int dimensionId, BlockPos blockPos) {
        return new DimPos(dimensionId, blockPos);
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public WeakReference<World> getWorldReference() {
        return this.worldReference;
    }

    public void setWorldReference(WeakReference<World> worldReference) {
        this.worldReference = worldReference;
    }

    public String toString() {
        return "DimPos(dimensionId=" + this.getDimensionId() + ", blockPos=" + this.getBlockPos() + ", worldReference=" + this.getWorldReference() + ")";
    }
}

