/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.cyclops.cyclopscore.advancement.criterion.BaseCriterionTrigger;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class ModItemObtainedTrigger
extends BaseCriterionTrigger<ItemStack, Instance> {
    public ModItemObtainedTrigger() {
        super(new ResourceLocation("cyclopscore", "mod_item_obtained"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new Instance(this.func_192163_a(), json.get("mod_id").getAsString());
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            this.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null && event.player instanceof EntityPlayerMP) {
            this.trigger((EntityPlayerMP)event.player, event.crafting);
        }
    }

    @SubscribeEvent
    public void onSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player != null && event.player instanceof EntityPlayerMP) {
            this.trigger((EntityPlayerMP)event.player, event.smelting);
        }
    }

    public static class Instance
    extends AbstractCriterionInstance
    implements ICriterionInstanceTestable<ItemStack> {
        private final String modId;

        public Instance(ResourceLocation criterionIn, String modId) {
            super(criterionIn);
            this.modId = modId;
        }

        @Override
        public boolean test(EntityPlayerMP player, ItemStack itemStack) {
            return !itemStack.func_190926_b() && ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b())).func_110624_b().equals(this.modId);
        }
    }
}

