/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.thaumcraft;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.aspect.Aspects;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.aspect.read.ThaumcraftAspects;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.client.render.valuetype.AspectValueTypeWorldRenderer;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.evaluate.operator.OperatorBuilders;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.evaluate.variable.ValueObjectTypeAspect;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.evaluate.variable.ValueTypeListAllAspects;
import org.cyclops.integrateddynamicscompat.modcompat.thaumcraft.evaluate.variable.ValueTypeListProxyPositionedAspectContainer;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftModCompat
implements IModCompat {
    public static ValueObjectTypeAspect OBJECT_ASPECT;
    public static ValueTypeListProxyNBTFactory<ValueObjectTypeAspect, ValueObjectTypeAspect.ValueAspect, ValueTypeListProxyPositionedAspectContainer> POSITIONED_ASPECTCONTAINER;
    public static ValueTypeListAllAspects.Factory ALL_ASPECTS;

    public String getModID() {
        return "thaumcraft";
    }

    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.PREINIT) {
            OBJECT_ASPECT = ValueTypes.REGISTRY.register(new ValueObjectTypeAspect());
            Aspects.REGISTRY.register((IPartType)PartTypes.MACHINE_READER, Lists.newArrayList((Object[])new IAspect[]{ThaumcraftAspects.Read.Aspect.BOOLEAN_ISASPECTCONTAINER, ThaumcraftAspects.Read.Aspect.LIST_ASPECTCONTAINER, ThaumcraftAspects.Read.Aspect.ASPECT, ThaumcraftAspects.Read.Aspect.BOOLEAN_ISESSENTIATRANSPORT, ThaumcraftAspects.Read.Aspect.BOOLEAN_ISESSENTIARECEIVER, ThaumcraftAspects.Read.Aspect.BOOLEAN_ISESSENTIAPROVIDER, ThaumcraftAspects.Read.Aspect.ASPECT_ESSENTIATRANSPORTSUCTION, ThaumcraftAspects.Read.Aspect.ASPECT_ESSENTIATRANSPORTSUCTIONASPECT, ThaumcraftAspects.Read.Aspect.ASPECT_ESSENTIATRANSPORTCONTENTS, ThaumcraftAspects.Read.Aspect.INTEGER_ESSENTIATRANSPORT_MINSUCTION}));
            Aspects.REGISTRY.register((IPartType)PartTypes.WORLD_READER, Lists.newArrayList((Object[])new IAspect[]{ThaumcraftAspects.Read.Aspect.DOUBLE_AURA_VIS, ThaumcraftAspects.Read.Aspect.DOUBLE_AURA_FLUX, ThaumcraftAspects.Read.Aspect.INTEGER_AURA_BASE}));
            Aspects.REGISTRY.register((IPartType)PartTypes.EXTRADIMENSIONAL_READER, Lists.newArrayList((Object[])new IAspect[]{ThaumcraftAspects.Read.Aspect.LIST_ALL_ASPECTS}));
            POSITIONED_ASPECTCONTAINER = ValueTypeListProxyFactories.REGISTRY.register(new ValueTypeListProxyNBTFactory("integrateddynamicscompat:thaumcraft:positionedAspectContainer", ValueTypeListProxyPositionedAspectContainer.class));
            ALL_ASPECTS = ValueTypeListProxyFactories.REGISTRY.register(new ValueTypeListAllAspects.Factory());
            Operators.REGISTRY.register(org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("aspects").operatorName("getitemthaumcraftaspects").function(variables -> {
                ItemStack a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
                if (!a.func_190926_b()) {
                    AspectList aspectList = AspectHelper.getObjectAspects((ItemStack)a);
                    Aspect[] aspectArray = aspectList.getAspectsSortedByAmount();
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)aspectArray.length);
                    for (Aspect aspect : aspectArray) {
                        list.add(ValueObjectTypeAspect.ValueAspect.of(aspect, aspectList.getAmount(aspect)));
                    }
                    return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, list);
                }
                return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, Collections.emptyList());
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("amount").function(OperatorBuilders.FUNCTION_ASPECT_TO_INT.build(input -> input != null ? (Integer)input.getRight() : Integer.valueOf(0))).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_2.output(ValueTypes.BOOLEAN).symbol("=Aspect=").operatorName("israwaspectequal").function(variables -> {
                Optional a = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(0)).getRawValue();
                Optional b = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(1)).getRawValue();
                boolean equal = false;
                if (a.isPresent() && b.isPresent()) {
                    equal = ((Aspect)((Pair)a.get()).getKey()).equals(((Pair)b.get()).getKey());
                } else if (!a.isPresent() && !b.isPresent()) {
                    equal = true;
                }
                return ValueTypeBoolean.ValueBoolean.of(equal);
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("compound_aspects").operatorName("getcompoundaspects").function(variables -> {
                Optional a = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(0)).getRawValue();
                if (a.isPresent()) {
                    Aspect[] aspectArray = ((Aspect)((Pair)a.get()).getKey()).getComponents();
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)aspectArray.length);
                    for (Aspect aspect : aspectArray) {
                        list.add(ValueObjectTypeAspect.ValueAspect.of(aspect, 1));
                    }
                    return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, list);
                }
                return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, Collections.emptyList());
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_2.symbol("combination_aspect").operatorName("getcombinationaspect").function(variables -> {
                Aspect aspect;
                Optional a = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(0)).getRawValue();
                Optional b = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(1)).getRawValue();
                if (a.isPresent() && b.isPresent() && (aspect = AspectHelper.getCombinationResult((Aspect)((Aspect)((Pair)a.get()).getLeft()), (Aspect)((Aspect)((Pair)b.get()).getLeft()))) != null) {
                    return ValueObjectTypeAspect.ValueAspect.of(aspect, 1);
                }
                return ValueObjectTypeAspect.ValueAspect.ofNull();
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isprimal").function(OperatorBuilders.FUNCTION_ASPECT_TO_BOOLEAN.build(input -> input != null && ((Aspect)input.getLeft()).isPrimal())).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.inputType(ValueTypes.OBJECT_ENTITY).output(ValueTypes.LIST).symbol("entity_aspects").operatorName("entityaspects").function(variables -> {
                AspectList aspectList;
                Optional<Entity> a = ((ValueObjectTypeEntity.ValueEntity)variables.getValue(0)).getRawValue();
                ArrayList aspects = Lists.newArrayList();
                if (a.isPresent() && (aspectList = AspectHelper.getEntityAspects((Entity)((Entity)a.get()))) != null) {
                    for (Aspect aspect : aspectList.getAspects()) {
                        aspects.add(ValueObjectTypeAspect.ValueAspect.of(aspect, aspectList.getAmount(aspect)));
                    }
                }
                return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, aspects);
            }).build());
            if (MinecraftHelpers.isClientSide()) {
                this.initClient();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void initClient() {
        ValueTypeWorldRenderers.REGISTRY.register(OBJECT_ASPECT, new AspectValueTypeWorldRenderer());
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Thaumcraft reader.";
    }
}

