/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.DistinctIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionMutableWrapper;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;

public class IngredientPositionsIndex<T, M>
extends IngredientCollectionMutableWrapper<T, M, IngredientCollectionPrototypeMap<T, M>>
implements IIngredientPositionsIndex<T, M> {
    private final IIngredientMapMutable<T, M, TreeSet<PrioritizedPartPos>> positionsMap;

    public IngredientPositionsIndex(IngredientComponent<T, M> component) {
        super((IIngredientCollectionMutable)new IngredientCollectionPrototypeMap(component, false));
        this.positionsMap = new IngredientHashMap(component);
    }

    protected T getPrototype(T instance) {
        return (T)this.positionsMap.getComponent().getMatcher().withQuantity(instance, 1L);
    }

    @Override
    public Iterator<PartPos> getNonEmptyPositions() {
        return this.getPositions(this.getComponent().getMatcher().getEmptyInstance(), this.getComponent().getMatcher().getAnyMatchCondition());
    }

    @Override
    public Iterator<PartPos> getPositions(T instance, M matchFlags) {
        return new DistinctIterator(this.positionsMap.getAll(this.getPrototype(instance), matchFlags).stream().flatMap(Collection::stream).map(PrioritizedPartPos::getPartPos).iterator());
    }

    @Override
    public void addPosition(T instance, PrioritizedPartPos pos) {
        T prototype = this.getPrototype(instance);
        TreeSet set = (TreeSet)this.positionsMap.get(prototype);
        if (set == null) {
            set = Sets.newTreeSet();
            this.positionsMap.put(prototype, (Object)set);
        }
        set.add(pos);
    }

    @Override
    public void removePosition(T instance, PrioritizedPartPos pos) {
        T prototype = this.getPrototype(instance);
        TreeSet set = (TreeSet)this.positionsMap.get(prototype);
        if (set != null) {
            set.remove(pos);
            if (set.isEmpty()) {
                this.positionsMap.remove(prototype);
            }
        }
    }

    @Override
    public long getQuantity(T instance) {
        return ((IngredientCollectionPrototypeMap)this.getInnerCollection()).getQuantity(instance);
    }
}

