/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Objects;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;

public class Variable<V extends IValue>
extends VariableAdapter<V> {
    private final IValueType<V> type;
    private final V value;

    public Variable(IValueType<V> type, V value) {
        this.type = type;
        this.value = value;
    }

    public Variable(V value) {
        this(value.getType(), value);
    }

    @Override
    public IValueType<V> getType() {
        return this.type;
    }

    @Override
    public V getValue() throws EvaluationException {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.type, variable.type) && Objects.equals(this.value, variable.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }
}

